// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateHTTPCheckBackendCreatedCode is the HTTP code returned for type CreateHTTPCheckBackendCreated
const CreateHTTPCheckBackendCreatedCode int = 201

/*
CreateHTTPCheckBackendCreated HTTP check created

swagger:response createHttpCheckBackendCreated
*/
type CreateHTTPCheckBackendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPCheck `json:"body,omitempty"`
}

// NewCreateHTTPCheckBackendCreated creates CreateHTTPCheckBackendCreated with default headers values
func NewCreateHTTPCheckBackendCreated() *CreateHTTPCheckBackendCreated {

	return &CreateHTTPCheckBackendCreated{}
}

// WithPayload adds the payload to the create Http check backend created response
func (o *CreateHTTPCheckBackendCreated) WithPayload(payload *models.HTTPCheck) *CreateHTTPCheckBackendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http check backend created response
func (o *CreateHTTPCheckBackendCreated) SetPayload(payload *models.HTTPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPCheckBackendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPCheckBackendAcceptedCode is the HTTP code returned for type CreateHTTPCheckBackendAccepted
const CreateHTTPCheckBackendAcceptedCode int = 202

/*
CreateHTTPCheckBackendAccepted Configuration change accepted and reload requested

swagger:response createHttpCheckBackendAccepted
*/
type CreateHTTPCheckBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPCheck `json:"body,omitempty"`
}

// NewCreateHTTPCheckBackendAccepted creates CreateHTTPCheckBackendAccepted with default headers values
func NewCreateHTTPCheckBackendAccepted() *CreateHTTPCheckBackendAccepted {

	return &CreateHTTPCheckBackendAccepted{}
}

// WithReloadID adds the reloadId to the create Http check backend accepted response
func (o *CreateHTTPCheckBackendAccepted) WithReloadID(reloadID string) *CreateHTTPCheckBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Http check backend accepted response
func (o *CreateHTTPCheckBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Http check backend accepted response
func (o *CreateHTTPCheckBackendAccepted) WithPayload(payload *models.HTTPCheck) *CreateHTTPCheckBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http check backend accepted response
func (o *CreateHTTPCheckBackendAccepted) SetPayload(payload *models.HTTPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPCheckBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPCheckBackendBadRequestCode is the HTTP code returned for type CreateHTTPCheckBackendBadRequest
const CreateHTTPCheckBackendBadRequestCode int = 400

/*
CreateHTTPCheckBackendBadRequest Bad request

swagger:response createHttpCheckBackendBadRequest
*/
type CreateHTTPCheckBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPCheckBackendBadRequest creates CreateHTTPCheckBackendBadRequest with default headers values
func NewCreateHTTPCheckBackendBadRequest() *CreateHTTPCheckBackendBadRequest {

	return &CreateHTTPCheckBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http check backend bad request response
func (o *CreateHTTPCheckBackendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateHTTPCheckBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http check backend bad request response
func (o *CreateHTTPCheckBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http check backend bad request response
func (o *CreateHTTPCheckBackendBadRequest) WithPayload(payload *models.Error) *CreateHTTPCheckBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http check backend bad request response
func (o *CreateHTTPCheckBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPCheckBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPCheckBackendConflictCode is the HTTP code returned for type CreateHTTPCheckBackendConflict
const CreateHTTPCheckBackendConflictCode int = 409

/*
CreateHTTPCheckBackendConflict The specified resource already exists

swagger:response createHttpCheckBackendConflict
*/
type CreateHTTPCheckBackendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPCheckBackendConflict creates CreateHTTPCheckBackendConflict with default headers values
func NewCreateHTTPCheckBackendConflict() *CreateHTTPCheckBackendConflict {

	return &CreateHTTPCheckBackendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http check backend conflict response
func (o *CreateHTTPCheckBackendConflict) WithConfigurationVersion(configurationVersion string) *CreateHTTPCheckBackendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http check backend conflict response
func (o *CreateHTTPCheckBackendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http check backend conflict response
func (o *CreateHTTPCheckBackendConflict) WithPayload(payload *models.Error) *CreateHTTPCheckBackendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http check backend conflict response
func (o *CreateHTTPCheckBackendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPCheckBackendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateHTTPCheckBackendDefault General Error

swagger:response createHttpCheckBackendDefault
*/
type CreateHTTPCheckBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPCheckBackendDefault creates CreateHTTPCheckBackendDefault with default headers values
func NewCreateHTTPCheckBackendDefault(code int) *CreateHTTPCheckBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateHTTPCheckBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create HTTP check backend default response
func (o *CreateHTTPCheckBackendDefault) WithStatusCode(code int) *CreateHTTPCheckBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create HTTP check backend default response
func (o *CreateHTTPCheckBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create HTTP check backend default response
func (o *CreateHTTPCheckBackendDefault) WithConfigurationVersion(configurationVersion string) *CreateHTTPCheckBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create HTTP check backend default response
func (o *CreateHTTPCheckBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create HTTP check backend default response
func (o *CreateHTTPCheckBackendDefault) WithPayload(payload *models.Error) *CreateHTTPCheckBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create HTTP check backend default response
func (o *CreateHTTPCheckBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPCheckBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
