// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllACLFrontendOKCode is the HTTP code returned for type ReplaceAllACLFrontendOK
const ReplaceAllACLFrontendOKCode int = 200

/*
ReplaceAllACLFrontendOK All ACL lines replaced

swagger:response replaceAllAclFrontendOK
*/
type ReplaceAllACLFrontendOK struct {

	/*
	  In: Body
	*/
	Payload models.Acls `json:"body,omitempty"`
}

// NewReplaceAllACLFrontendOK creates ReplaceAllACLFrontendOK with default headers values
func NewReplaceAllACLFrontendOK() *ReplaceAllACLFrontendOK {

	return &ReplaceAllACLFrontendOK{}
}

// WithPayload adds the payload to the replace all Acl frontend o k response
func (o *ReplaceAllACLFrontendOK) WithPayload(payload models.Acls) *ReplaceAllACLFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Acl frontend o k response
func (o *ReplaceAllACLFrontendOK) SetPayload(payload models.Acls) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllACLFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Acls{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllACLFrontendAcceptedCode is the HTTP code returned for type ReplaceAllACLFrontendAccepted
const ReplaceAllACLFrontendAcceptedCode int = 202

/*
ReplaceAllACLFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceAllAclFrontendAccepted
*/
type ReplaceAllACLFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.Acls `json:"body,omitempty"`
}

// NewReplaceAllACLFrontendAccepted creates ReplaceAllACLFrontendAccepted with default headers values
func NewReplaceAllACLFrontendAccepted() *ReplaceAllACLFrontendAccepted {

	return &ReplaceAllACLFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace all Acl frontend accepted response
func (o *ReplaceAllACLFrontendAccepted) WithReloadID(reloadID string) *ReplaceAllACLFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all Acl frontend accepted response
func (o *ReplaceAllACLFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all Acl frontend accepted response
func (o *ReplaceAllACLFrontendAccepted) WithPayload(payload models.Acls) *ReplaceAllACLFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Acl frontend accepted response
func (o *ReplaceAllACLFrontendAccepted) SetPayload(payload models.Acls) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllACLFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Acls{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllACLFrontendBadRequestCode is the HTTP code returned for type ReplaceAllACLFrontendBadRequest
const ReplaceAllACLFrontendBadRequestCode int = 400

/*
ReplaceAllACLFrontendBadRequest Bad request

swagger:response replaceAllAclFrontendBadRequest
*/
type ReplaceAllACLFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllACLFrontendBadRequest creates ReplaceAllACLFrontendBadRequest with default headers values
func NewReplaceAllACLFrontendBadRequest() *ReplaceAllACLFrontendBadRequest {

	return &ReplaceAllACLFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all Acl frontend bad request response
func (o *ReplaceAllACLFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllACLFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all Acl frontend bad request response
func (o *ReplaceAllACLFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all Acl frontend bad request response
func (o *ReplaceAllACLFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceAllACLFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Acl frontend bad request response
func (o *ReplaceAllACLFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllACLFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllACLFrontendDefault General Error

swagger:response replaceAllAclFrontendDefault
*/
type ReplaceAllACLFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllACLFrontendDefault creates ReplaceAllACLFrontendDefault with default headers values
func NewReplaceAllACLFrontendDefault(code int) *ReplaceAllACLFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllACLFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all Acl frontend default response
func (o *ReplaceAllACLFrontendDefault) WithStatusCode(code int) *ReplaceAllACLFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all Acl frontend default response
func (o *ReplaceAllACLFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all Acl frontend default response
func (o *ReplaceAllACLFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllACLFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all Acl frontend default response
func (o *ReplaceAllACLFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all Acl frontend default response
func (o *ReplaceAllACLFrontendDefault) WithPayload(payload *models.Error) *ReplaceAllACLFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Acl frontend default response
func (o *ReplaceAllACLFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllACLFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
