# Garmin Aera660 Simulation by D-ECHO based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)
#######################################

var aera660_mainmenu = nil;
var aera660_map = nil;
var aera660_start = nil;
var aera660_display = nil;

var path = "Aircraft/AlphaElectro/Models/Instruments/Aera660/";

var page = "main_menu";

var volts_p = props.globals.getNode("/systems/electrical/outputs/gps", 1);

var state = 0;	# 0 = off, 1 = starting, 2 = on

var canvas_aera660_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volts = volts_p.getDoubleValue();
		if ( volts > 10 and state == 2) {
			aera660_start.page.hide();
			if( page == "main_menu" ){
				aera660_mainmenu.page.show();
				aera660_map.hide();
			}else if( page == "map" ){
				aera660_map.show();
				aera660_map.update();
				aera660_mainmenu.page.hide();
			}else{
				aera660_mainmenu.page.hide();
				aera660_map.hide();
			}
		} else if ( volts > 10 and state == 1 ){
			aera660_mainmenu.page.hide();
			aera660_map.hide();
			aera660_start.page.show();
		} else {
			aera660_mainmenu.page.hide();
			aera660_map.hide();
			aera660_start.page.hide();
		}
	},
};
	
	
var canvas_aera660_mainmenu = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_aera660_mainmenu , canvas_aera660_base] };
		m.init(canvas_group, file);
		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
	}
	
};


var canvas_aera660_start = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_aera660_start , canvas_aera660_base] };
		m.init(canvas_group, file);
		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
	}
	
};

var base_updater = maketimer( 0.1, canvas_aera660_base.update );
base_updater.simulatedTime = 1;

var ls = setlistener("sim/signals/fdm-initialized", func {
	removelistener( ls );
	aera660_display = canvas.new({
		"name": "Aera660",
		"size": [800, 480],
		"view": [800, 480],
		"mipmapping": 1
	});
	aera660_display.addPlacement({"node": "aera660.screen"});

	aera660_mainmenu = canvas_aera660_mainmenu.new( aera660_display.createGroup(), 	path~"aera660.main_menu.svg");
	aera660_map = canvas_nd.new( aera660_display.createGroup() );
	aera660_start = canvas_aera660_start.new( aera660_display.createGroup(), 		path~"aera660.start.svg");
	
	base_updater.start();
});

#Touchscreen

var click1 = func () {
	if(page=="main_menu"){
		page="map";
	}
}

#End Touchscreen

var power_btn = func{
	page="main_menu";
	if( state == 0 and volts_p.getDoubleValue() ){
		state = 1;
		settimer( func{ state = 2 }, 2 );
	} elsif ( volts_p.getDoubleValue() < 10 ){
		state = 0;
	}
}

setlistener(volts_p, func{
	if(volts_p.getValue() < 10){
		state = 0;
	}
});
