###############################################################################
## 
## Nasal for MP-passenger on the ASK-13 over the multiplayer network.
##
##  Copyright (C) 2010 Patrice Poly, based on dual control by
##  Anders Gidenstam  :  http://www.gidenstam.org/FlightGear/DualControl/
##  This file is licensed under the GPL license version 2 or later.
##
###############################################################################

# Renaming (almost :)
var DCT = dual_control_tools;

var wrappers = ["instrumentation/magnetic-compass/indicated-heading-deg","instrumentation/airspeed-indicator/indicated-speed-kt","instrumentation/mc-cready/rot","instrumentation/altimeter/indicated-altitude-ft"];

######################################################################
# Pilot/copilot aircraft identifiers. Used by dual_control.
var pilot_type   = "Aircraft/ASK13/Models/ask13.xml";
var copilot_type = "Aircraft/ASK13/Models/ask13-passenger.xml";

props.globals.initNode("/sim/remote/pilot-callsign", "", "STRING");

######################################################################
# MP enabled properties.
# NOTE: These must exist very early during startup - put them
#       in the -set.xml file.


######################################################################
# Useful local property paths.

######################################################################
# Slow state properties for replication.


###############################################################################
# Pilot MP property mappings and specific copilot connect/disconnect actions.


######################################################################
# Used by dual_control to set up the mappings for the pilot.
var pilot_connect_copilot = func (copilot) {
	return 
	[
	######################################################################
	# Process received properties.
	######################################################################
	######################################################################
	# Process properties to send.
	######################################################################
	];
}

######################################################################
var pilot_disconnect_copilot = func {
}


###############################################################################
# Copilot MP property mappings and specific pilot connect/disconnect actions.


######################################################################
# Used by dual_control to set up the mappings for the copilot.
var copilot_connect_pilot = func (pilot) {
	# Initialize Nasal wrappers for copilot pick anaimations.
	set_copilot_wrappers(pilot);
	
	forindex(var i; wrappers){
		# TODO
		#var p=wrappers[i];
		#print(p);
		#props.globals.initNode(p);
		#props.globals.getNode(p).alias(pilot.getNode(p));
	}
	
	return
	[
	######################################################################
	# Process received properties.
	######################################################################
	######################################################################
	# Process properties to send.
	######################################################################
	];
}

######################################################################
var copilot_disconnect_pilot = func {
	# Reset local sound properties.
	
	forindex(var i; wrappers){
		# TODO
		#var p=wrappers[i];
		#print("delete" ~ p);
		#props.globals.getNode(p).unalias();
		#props.globals.getNode(p).setValue(0);
	}
}

######################################################################
# Copilot Nasal wrappers

var set_copilot_wrappers = func (pilot) {
	
	# Setup aliases to drive local sound.
	
}
