/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.core;

import java.util.HashMap;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.core.Operator;
import org.eclipse.xwt.core.SetterBase;
import org.eclipse.xwt.core.TriggerBase;
import org.eclipse.xwt.databinding.JFaceXWTDataBinding;
import org.eclipse.xwt.internal.core.ScopeManager;
import org.eclipse.xwt.internal.core.UpdateSourceTrigger;
import org.eclipse.xwt.internal.utils.LoggerManager;
import org.eclipse.xwt.internal.utils.UserData;

public class Trigger
extends TriggerBase {
    private String property;
    private String sourceName;
    private Operator operator = Operator.EQ;
    private Object value;
    private SetterBase[] setters;

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public SetterBase[] getSetters() {
        if (this.setters == null) {
            return SetterBase.EMPTY_SETTERS;
        }
        return this.setters;
    }

    public void setSetters(SetterBase[] setters) {
        this.setters = setters;
    }

    @Override
    public void on(Object target) {
    }

    @Override
    public void prepare(Object target) {
        if (this.property != null) {
            final Object source = Trigger.getElementByName(target, this.sourceName);
            if (source == null) {
                throw new XWTException("No element is found with the name = " + this.sourceName);
            }
            IObservableValue observableValue = ScopeManager.observeValue(source, source, this.property, UpdateSourceTrigger.PropertyChanged);
            observableValue.addChangeListener((IChangeListener)new TriggerBase.AbstractChangeListener(this, target){

                public void handleChange(ChangeEvent event) {
                    IConverter newConverter;
                    Object newValue;
                    IConverter converter;
                    Class<?> valueType = JFaceXWTDataBinding.getValueType(source.getClass(), Trigger.this.property);
                    if (valueType == null) {
                        LoggerManager.log("Type of the property " + Trigger.this.property + " is not found in " + source.getClass().getName());
                        return;
                    }
                    Widget widget = UserData.getWidget(source);
                    if (widget == null) {
                        return;
                    }
                    Object realValue = Trigger.this.value;
                    if (Trigger.this.value != null && (converter = XWT.findConvertor(Trigger.this.value.getClass(), valueType)) != null) {
                        realValue = converter.convert(Trigger.this.value);
                    }
                    if ((newValue = event.getSource()) instanceof IObservableValue) {
                        IObservableValue observableValue = (IObservableValue)newValue;
                        newValue = observableValue.getValue();
                    }
                    if (newValue != null && (newConverter = XWT.findConvertor(newValue.getClass(), valueType)) != null) {
                        newValue = newConverter.convert(newValue);
                    }
                    if (!Operator.compare(newValue, Trigger.this.operator, realValue)) {
                        this.restoreValues();
                        if (this.oldvalues != null) {
                            this.oldvalues.clear();
                        }
                        return;
                    }
                    if (this.oldvalues != null && !this.oldvalues.isEmpty()) {
                        return;
                    }
                    SetterBase[] setterBaseArray = Trigger.this.getSetters();
                    int n = setterBaseArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SetterBase setter = setterBaseArray[n2];
                        try {
                            Object oldValue = setter.applyTo(this.element, true);
                            if (this.oldvalues == null) {
                                this.oldvalues = new HashMap();
                            }
                            this.oldvalues.put(setter, oldValue);
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                        ++n2;
                    }
                }
            });
        }
    }
}

