/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.jdt.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.Messages;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.IDialogFieldListener;
import org.eclipse.wb.internal.core.utils.dialogfields.IStringButtonAdapter;
import org.eclipse.wb.internal.core.utils.dialogfields.StatusUtils;
import org.eclipse.wb.internal.core.utils.dialogfields.StringButtonDialogField;
import org.eclipse.wb.internal.core.utils.jdt.ui.IPackageRootChangeListener;
import org.eclipse.wb.internal.core.utils.jdt.ui.IPackageRootFilter;

public final class PackageRootSelectionDialogField
extends StringButtonDialogField
implements IDialogFieldListener {
    private IPackageRootFilter m_packageRootFilter;
    private IDialogFieldListener m_updateListener;
    private IPackageRootChangeListener m_listener;
    private IPackageFragmentRoot m_root;

    public static PackageRootSelectionDialogField create(String label, String buttonLabel) {
        ButtonAdapter adapter = new ButtonAdapter();
        PackageRootSelectionDialogField field = new PackageRootSelectionDialogField(label, buttonLabel, adapter);
        adapter.setReceiver(field);
        return field;
    }

    private PackageRootSelectionDialogField(String label, String buttonLabel, IStringButtonAdapter adapter) {
        super(adapter);
        this.setLabelText(label);
        this.setButtonLabel(buttonLabel);
        this.setDialogFieldListener(this);
    }

    public void setPackageRootFilter(IPackageRootFilter packageRootFilter) {
        this.m_packageRootFilter = packageRootFilter;
    }

    public void setCompilationUnit(ICompilationUnit unit) {
        IPackageFragment pkg = (IPackageFragment)unit.getParent();
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
        this.setRoot(root);
    }

    public void setUpdateListener(IDialogFieldListener updateListener) {
        this.m_updateListener = updateListener;
    }

    public void setListener(IPackageRootChangeListener changeListener) {
        this.m_listener = changeListener;
    }

    public IPackageFragmentRoot getRoot() {
        return this.m_root;
    }

    public void setRoot(IPackageFragmentRoot packageFragmentRoot) {
        this.m_root = packageFragmentRoot;
        if (this.m_root != null) {
            String newText = PackageRootSelectionDialogField.getRootString(this.m_root);
            if (!this.getText().equals(newText)) {
                this.setText(newText);
            }
        }
        if (this.m_listener != null) {
            this.m_listener.rootChanged(this.m_root);
        }
        if (this.m_updateListener != null) {
            this.m_updateListener.dialogFieldChanged((DialogField)this);
        }
    }

    public void setRootWithoutUpdate(IPackageFragmentRoot packageFragmentRoot) {
        this.m_root = packageFragmentRoot;
        if (this.m_root != null) {
            String newText = PackageRootSelectionDialogField.getRootString(this.m_root);
            if (!this.getText().equals(newText)) {
                this.setTextWithoutUpdate(newText);
            }
        }
        if (this.m_listener != null) {
            this.m_listener.rootChanged(this.m_root);
        }
    }

    public void dialogFieldChanged(DialogField field) {
        this.setRoot(PackageRootSelectionDialogField.getRootFromString(this.getText()));
    }

    private static String getRootString(IPackageFragmentRoot root) {
        return root == null ? "" : root.getPath().makeRelative().toString();
    }

    private static IPackageFragmentRoot getRootFromString(String rootString) {
        if (rootString.length() == 0) {
            return null;
        }
        Path path = new Path(rootString);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = workspaceRoot.findMember((IPath)path);
        if (resource == null) {
            return null;
        }
        int resourceType = resource.getType();
        if (resourceType == 4 || resourceType == 2) {
            IProject project = resource.getProject();
            if (!project.isOpen()) {
                return null;
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPackageFragmentRoot root = javaProject.getPackageFragmentRoot(resource);
            if (root.exists()) {
                return root;
            }
        }
        return null;
    }

    private static class ButtonAdapter
    implements IStringButtonAdapter {
        private PackageRootSelectionDialogField m_receiver;
        private final ViewerFilter m_javaFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IJavaProject) {
                    if (m_receiver.m_packageRootFilter != null) {
                        return m_receiver.m_packageRootFilter.select((IJavaProject)element);
                    }
                    return true;
                }
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)element;
                        if (packageFragmentRoot.getKind() == 1) {
                            if (m_receiver.m_packageRootFilter != null) {
                                return m_receiver.m_packageRootFilter.select(packageFragmentRoot);
                            }
                            return true;
                        }
                    }
                    catch (JavaModelException e) {
                        DesignerPlugin.log((Throwable)e);
                        return false;
                    }
                }
                return false;
            }
        };

        private ButtonAdapter() {
        }

        public void setReceiver(PackageRootSelectionDialogField receiver) {
            this.m_receiver = receiver;
        }

        public void changeControlPressed(DialogField field) {
            IPackageFragmentRoot root = this.selectSourceFolder(this.m_receiver.m_root);
            if (root != null) {
                this.m_receiver.setRoot(root);
            }
        }

        private IPackageFragmentRoot selectSourceFolder(IPackageFragmentRoot initialSelection) {
            Shell shell = Display.getCurrent().getActiveShell();
            JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
            StandardJavaElementContentProvider contentProvider = new StandardJavaElementContentProvider();
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
            dialog.setTitle(Messages.PackageRootSelectionDialogField_dialogTitle);
            dialog.setMessage(Messages.PackageRootSelectionDialogField_dialogMessage);
            dialog.setSorter((ViewerSorter)new JavaElementSorter());
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    Object element;
                    if (selection.length == 1 && this.isElementValid(element = selection[0])) {
                        return StatusUtils.OK_STATUS;
                    }
                    return StatusUtils.ERROR_STATUS;
                }

                public boolean isElementValid(Object element) {
                    try {
                        if (element instanceof IJavaProject) {
                            IJavaProject project = (IJavaProject)element;
                            IPath path = project.getProject().getFullPath();
                            return project.findPackageFragmentRoot(path) != null;
                        }
                        if (element instanceof IPackageFragmentRoot) {
                            return ((IPackageFragmentRoot)element).getKind() == 1;
                        }
                        return true;
                    }
                    catch (JavaModelException e) {
                        DesignerPlugin.log((Throwable)e);
                        return false;
                    }
                }
            });
            dialog.addFilter(this.m_javaFilter);
            dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
            dialog.setInitialSelection((Object)initialSelection);
            if (dialog.open() == 0) {
                Object element = dialog.getFirstResult();
                if (element instanceof IJavaProject) {
                    IJavaProject javaProject = (IJavaProject)element;
                    return javaProject.getPackageFragmentRoot((IResource)javaProject.getProject());
                }
                if (element instanceof IPackageFragmentRoot) {
                    return (IPackageFragmentRoot)element;
                }
                return null;
            }
            return null;
        }
    }
}

