/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.gef.part;

import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.gef.policy.selection.LineSelectionEditPolicy;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.requests.SelectionRequest;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.xwt.model.jface.ViewerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerEditPart
extends GraphicalEditPart {
    private final ViewerInfo m_viewer;

    public ViewerEditPart(ViewerInfo viewer) {
        this.setModel((Object)viewer);
        this.m_viewer = viewer;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new LineSelectionEditPolicy(IColorConstants.black){

            protected org.eclipse.wb.draw2d.geometry.Rectangle getHostBounds() {
                org.eclipse.wb.draw2d.geometry.Rectangle bounds = ViewerEditPart.this.getIconBounds();
                bounds.translate(this.getHostFigure().getLocation());
                return bounds;
            }
        });
    }

    protected Figure createFigure() {
        return new Figure(){

            protected void paintClientArea(Graphics graphics) {
                org.eclipse.wb.draw2d.geometry.Rectangle iconBounds = ViewerEditPart.this.getIconBounds();
                graphics.drawImage(ViewerEditPart.this.m_viewer.getDescription().getIcon(), iconBounds.x, iconBounds.y);
            }
        };
    }

    protected void refreshVisuals() {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                org.eclipse.wb.draw2d.geometry.Rectangle bounds = ((GraphicalEditPart)ViewerEditPart.this.getParent()).getFigure().getClientArea();
                ViewerEditPart.this.getFigure().setBounds(bounds);
            }
        });
    }

    private org.eclipse.wb.draw2d.geometry.Rectangle getIconBounds() {
        Rectangle imageBounds = this.m_viewer.getDescription().getIcon().getBounds();
        int width = imageBounds.width;
        int height = imageBounds.height;
        Point location = this.getFigure().getBounds().getBottomRight().getTranslated(-width, -height);
        location.translate(-3, -3);
        return new org.eclipse.wb.draw2d.geometry.Rectangle(location.x, location.y, width, height);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof SelectionRequest) {
            SelectionRequest selectionRequest = (SelectionRequest)request;
            Point location = selectionRequest.getLocation();
            if (location == null) {
                return this;
            }
            location = location.getCopy();
            FigureUtils.translateAbsoluteToFigure2((Figure)this.getFigure(), (Translatable)location);
            if (!this.getIconBounds().contains(location)) {
                return this.getParent().getTargetEditPart(request);
            }
        }
        return super.getTargetEditPart(request);
    }

    protected List<?> getModelChildren() {
        return (List)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<List<?>>(){

            public List<?> runObject() throws Exception {
                return ViewerEditPart.this.m_viewer.getPresentation().getChildrenGraphical();
            }
        }, Collections.emptyList());
    }
}

