/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.form;

import java.text.MessageFormat;
import org.eclipse.wb.internal.swt.model.ModelMessages;

public final class FormLayoutUtils {
    public static int getOppositeSide(int side) {
        switch (side) {
            case 16384: {
                return 131072;
            }
            case 131072: {
                return 16384;
            }
            case 128: {
                return 1024;
            }
            case 1024: {
                return 128;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(ModelMessages.FormLayoutUtils_invalidSide, side));
    }

    public static int convertSwtAlignment(int alignment) {
        switch (alignment) {
            case 16384: {
                return 1;
            }
            case 131072: {
                return 4;
            }
            case 128: {
                return 8;
            }
            case 1024: {
                return 32;
            }
            case 0x1000000: {
                return 2;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(ModelMessages.FormLayoutUtils_invalidAlignment, alignment));
    }

    public static int convertGefSide(int side) {
        switch (side) {
            case 1: {
                return 16384;
            }
            case 4: {
                return 131072;
            }
            case 8: {
                return 128;
            }
            case 32: {
                return 1024;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(ModelMessages.FormLayoutUtils_invalidSide, side));
    }

    public static String getAlignmentSource(int alignment) {
        switch (alignment) {
            case 16384: {
                return "org.eclipse.swt.SWT.LEFT";
            }
            case 131072: {
                return "org.eclipse.swt.SWT.RIGHT";
            }
            case 128: {
                return "org.eclipse.swt.SWT.TOP";
            }
            case 1024: {
                return "org.eclipse.swt.SWT.BOTTOM";
            }
        }
        return "org.eclipse.swt.SWT.DEFAULT";
    }
}

