/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.snapping;

import java.util.List;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.gef.policy.snapping.IFeedbackProxy;
import org.eclipse.wb.internal.core.gef.policy.snapping.IVisualDataProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.SnapPoint;

public class ContainerSnapPoint
extends SnapPoint {
    protected Dimension m_containerSize;
    private final boolean m_includeGap;

    public ContainerSnapPoint(IVisualDataProvider visualDataProvider, int side) {
        this(visualDataProvider, side, false);
    }

    public ContainerSnapPoint(IVisualDataProvider visualDataProvider, int side, boolean includeGap) {
        super(visualDataProvider, side, side == 1 || side == 8 ? 0 : 1);
        this.m_includeGap = includeGap;
    }

    @Override
    protected void calculateSnapPoint(List<? extends IAbstractComponentInfo> beingSnappedList) {
        super.calculateSnapPoint(beingSnappedList);
        this.m_containerSize = this.m_visualDataProvider.getContainerSize();
        int gapValue = this.m_visualDataProvider.getContainerGapValue(this.m_nearestBeingSnapped, this.m_side);
        switch (this.m_side) {
            case 1: 
            case 8: {
                this.m_snapPoint = this.m_includeGap ? gapValue : 0;
                break;
            }
            case 32: {
                this.m_snapPoint = this.m_includeGap ? this.m_containerSize.height - gapValue : this.m_containerSize.height;
                break;
            }
            case 4: {
                this.m_snapPoint = this.m_includeGap ? this.m_containerSize.width - gapValue : this.m_containerSize.width;
                break;
            }
        }
    }

    @Override
    public void addFeedback(Rectangle snappedBounds, IFeedbackProxy feedbackProxy, List<Figure> feedbacks) {
        if (this.isHorizontal()) {
            feedbacks.add(feedbackProxy.addVerticalFeedbackLine(this.m_snapPoint, 0, this.m_containerSize.height));
        } else {
            feedbacks.add(feedbackProxy.addHorizontalFeedbackLine(this.m_snapPoint, 0, this.m_containerSize.width));
        }
    }

    @Override
    protected boolean checkDirection() {
        return false;
    }

    @Override
    protected String getObjectInfo() {
        return " gap=" + this.m_includeGap;
    }
}

