/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls.jface.preference;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class FieldLayoutPreferencePage
extends PreferencePage
implements IPropertyChangeListener {
    private final List<FieldEditor> fields = Lists.newArrayList();
    private FieldEditor invalidFieldEditor = null;

    protected FieldLayoutPreferencePage() {
    }

    protected FieldLayoutPreferencePage(String title) {
        super(title);
    }

    protected FieldLayoutPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected void addField(FieldEditor editor) {
        this.fields.add(editor);
    }

    protected void checkState() {
        boolean valid = true;
        this.invalidFieldEditor = null;
        for (FieldEditor fieldEditor : this.fields) {
            boolean bl = valid = valid && fieldEditor.isValid();
            if (valid) continue;
            this.invalidFieldEditor = fieldEditor;
            break;
        }
    }

    protected Control createContents(Composite parent) {
        Control contens = this.createPageContents(parent);
        this.initialize();
        this.checkState();
        return contens;
    }

    protected abstract Control createPageContents(Composite var1);

    public void dispose() {
        super.dispose();
        for (FieldEditor fieldEditor : this.fields) {
            fieldEditor.setPage(null);
            fieldEditor.setPropertyChangeListener(null);
            fieldEditor.setPreferenceStore(null);
        }
    }

    protected void initialize() {
        for (FieldEditor fieldEditor : this.fields) {
            fieldEditor.setPage(null);
            fieldEditor.setPropertyChangeListener((IPropertyChangeListener)this);
            fieldEditor.setPreferenceStore(this.getPreferenceStore());
            fieldEditor.load();
        }
    }

    protected void performDefaults() {
        for (FieldEditor fieldEditor : this.fields) {
            fieldEditor.loadDefault();
        }
        this.checkState();
        super.performDefaults();
    }

    public boolean performOk() {
        for (FieldEditor fieldEditor : this.fields) {
            fieldEditor.store();
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                this.checkState();
            } else {
                this.invalidFieldEditor = (FieldEditor)event.getSource();
            }
            this.setValid(newValue);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.invalidFieldEditor != null) {
            this.invalidFieldEditor.setFocus();
        }
    }
}

