/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
public class TestHTML {
    @Test
    public void testHTMLFile() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("testHTMLFile" + System.currentTimeMillis());
        project.create(null);
        project.open(null);
        final IFile file = project.getFile("blah.html");
        file.create((InputStream)new ByteArrayInputStream("FAIL".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).set("<style\n<html><");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length != 0;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Diagnostic not published");
    }

    @Test
    public void testFormat() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("testHTMLFile" + System.currentTimeMillis());
        project.create(null);
        project.open(null);
        IFile file = project.getFile("blah.html");
        file.create((InputStream)new ByteArrayInputStream("<html><body><a></a></body></html>".getBytes()), true, null);
        final ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        editor.setFocus();
        editor.getSelectionProvider().setSelection((ISelection)new TextSelection(0, 0));
        final IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        Assertions.assertTrue((boolean)((ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)).getCommand("org.eclipse.lsp4e.format").isEnabled());
        AtomicReference ex = new AtomicReference();
        new DisplayHelper(){

            protected boolean condition() {
                try {
                    handlerService.executeCommand("org.eclipse.lsp4e.format", null);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }.waitForCondition(editor.getSite().getShell().getDisplay(), 3000L);
        if (ex.get() != null) {
            throw (Exception)ex.get();
        }
        new DisplayHelper(){

            protected boolean condition() {
                return editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).getNumberOfLines() > 1;
            }
        }.waitForCondition(editor.getSite().getShell().getDisplay(), 3000L);
    }

    @Test
    public void autoCloseTags() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("testHTMLFile" + System.currentTimeMillis());
        project.create(null);
        project.open(null);
        IFile file = project.getFile("autoCloseTags.xml");
        file.create((InputStream)new ByteArrayInputStream("<foo".getBytes()), true, null);
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        final IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        document.replace(4, 0, ">");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                return "<foo></foo>".equals(document.get());
            }
        }.waitForCondition(PlatformUI.getWorkbench().getDisplay(), 5000L), (String)"Autoclose not done");
    }
}

