/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.ui.internal.model.DocumentInputStream;
import org.eclipse.tm4e.ui.utils.ClassHelper;
import org.eclipse.tm4e.ui.utils.ContentTypeInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class ContentTypeHelper {
    public static ContentTypeInfo findContentTypes(IDocument document) throws CoreException {
        ContentTypeInfo contentTypes = ContentTypeHelper.findContentTypesFromFileBuffers(document);
        if (contentTypes != null) {
            return contentTypes;
        }
        return ContentTypeHelper.findContentTypesFromEditorInput(document);
    }

    public static IContentType getContentTypeById(String contentTypeId) {
        IContentTypeManager manager = Platform.getContentTypeManager();
        return manager.getContentType(contentTypeId);
    }

    private static ContentTypeInfo findContentTypesFromFileBuffers(IDocument document) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer buffer = bufferManager.getTextFileBuffer(document);
        if (buffer != null) {
            return ContentTypeHelper.getContentTypes(buffer);
        }
        return null;
    }

    private static ContentTypeInfo getContentTypes(ITextFileBuffer buffer) throws CoreException {
        try {
            Object var5_8;
            Throwable throwable;
            String fileName = buffer.getFileStore().getName();
            LinkedHashSet<IContentType> contentTypes = new LinkedHashSet<IContentType>();
            IContentType bufferContentType = buffer.getContentType();
            if (bufferContentType != null) {
                contentTypes.add(bufferContentType);
            }
            if (buffer.isDirty()) {
                throwable = null;
                var5_8 = null;
                try (DocumentInputStream input = new DocumentInputStream(buffer.getDocument());){
                    IContentType[] contentTypesForInput = Platform.getContentTypeManager().findContentTypesFor((InputStream)input, fileName);
                    if (contentTypesForInput != null) {
                        contentTypes.addAll(Arrays.asList(contentTypesForInput));
                        return new ContentTypeInfo(fileName, (IContentType[])contentTypes.toArray(IContentType[]::new));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            try {
                throwable = null;
                var5_8 = null;
                try (InputStream contents = ContentTypeHelper.getContents(buffer);){
                    contentTypes.addAll(Arrays.asList(Platform.getContentTypeManager().findContentTypesFor(contents, fileName)));
                    return new ContentTypeInfo(fileName, (IContentType[])contentTypes.toArray(IContentType[]::new));
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable4) {
                return null;
            }
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
    }

    private static InputStream getContents(ITextFileBuffer buffer) throws CoreException {
        IWorkspaceRoot workspaceRoot;
        IFile file;
        IPath path = buffer.getLocation();
        if (path != null && (file = (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).getFile(path)).exists() && buffer.isSynchronized()) {
            return file.getContents();
        }
        return buffer.getFileStore().openInputStream(0, null);
    }

    /*
     * Loose catch block
     */
    private static ContentTypeInfo findContentTypesFromEditorInput(IDocument document) {
        IEditorInput editorInput = ContentTypeHelper.getEditorInput(document);
        if (editorInput != null && editorInput instanceof IStorageEditorInput) {
            InputStream input = null;
            IStorage storage = ((IStorageEditorInput)editorInput).getStorage();
            String fileName = storage.getName();
            input = storage.getContents();
            ContentTypeInfo contentTypeInfo = new ContentTypeInfo(fileName, Platform.getContentTypeManager().findContentTypesFor(input, fileName));
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
            return contentTypeInfo;
            catch (Exception exception) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        return null;
    }

    private static IEditorInput getEditorInput(IDocument document) {
        block6: {
            try {
                ListenerList listeners = (ListenerList)ClassHelper.getFieldValue(document, "fDocumentListeners");
                if (listeners == null) break block6;
                Object[] l = listeners.getListeners();
                int i = 0;
                while (i < l.length) {
                    Object info = l[i];
                    try {
                        Object input = ClassHelper.getFieldValue(info, "fElement");
                        if (input instanceof IEditorInput) {
                            return (IEditorInput)input;
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

