/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.core.internal.jsflibraryregistry;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class JSFVersion
extends AbstractEnumerator {
    public static final String copyright = "Copyright (c) 2005 Oracle Corporation";
    public static final int V1_1 = 1;
    public static final int V1_2 = 2;
    public static final int UNKNOWN = -1;
    public static final JSFVersion V1_1_LITERAL = new JSFVersion(1, "v1_1");
    public static final JSFVersion V1_2_LITERAL = new JSFVersion(2, "v1_2");
    public static final JSFVersion UNKNOWN_LITERAL = new JSFVersion(-1, "UNKNOWN");
    private static final JSFVersion[] VALUES_ARRAY = new JSFVersion[]{V1_1_LITERAL, V1_2_LITERAL, UNKNOWN_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static JSFVersion get(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JSFVersion result = VALUES_ARRAY[i];
            if (result.toString().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JSFVersion get(int value) {
        switch (value) {
            case 1: {
                return V1_1_LITERAL;
            }
            case 2: {
                return V1_2_LITERAL;
            }
            case -1: {
                return UNKNOWN_LITERAL;
            }
        }
        return null;
    }

    private JSFVersion(int value, String name) {
        super(value, name);
    }

    public static JSFVersion getJSFVersion(String name) {
        JSFVersion version = JSFVersion.get(name);
        if (version == null) {
            version = UNKNOWN_LITERAL;
        }
        return version;
    }
}

