/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.iterators.EnumerationIterator;

public class EnumerationIteratorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.EnumerationIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.EnumerationIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public EnumerationIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        Iterator stream = this.buildIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        EnumerationIteratorTests.assertEquals((int)this.buildVector().size(), (int)i);
    }

    public void testNext() {
        Enumeration enumeration = this.buildEnumeration();
        Iterator stream = this.buildIterator();
        while (stream.hasNext()) {
            EnumerationIteratorTests.assertEquals((String)"bogus element", enumeration.nextElement(), stream.next());
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator stream = this.buildIterator();
        String string = null;
        while (stream.hasNext()) {
            string = (String)stream.next();
        }
        try {
            string = (String)stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        EnumerationIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        Iterator stream = this.buildIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        EnumerationIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    private Iterator buildIterator() {
        return this.buildIterator(this.buildEnumeration());
    }

    private Iterator buildIterator(Enumeration enumeration) {
        return new EnumerationIterator(enumeration);
    }

    private Enumeration buildEnumeration() {
        return this.buildVector().elements();
    }

    private Vector buildVector() {
        Vector<String> v = new Vector<String>();
        v.addElement("one");
        v.addElement("two");
        v.addElement("three");
        v.addElement("four");
        v.addElement("five");
        v.addElement("six");
        v.addElement("seven");
        v.addElement("eight");
        return v;
    }
}

