/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters;

import org.eclipse.dali.core.Entity;
import org.eclipse.dali.core.adapters.IEntityModelAdapter;

public abstract class AbstractEntityModelAdapter
implements IEntityModelAdapter {
    private Entity entity;

    protected void engage(Entity entity, Object model) {
        this.entity = entity;
        this.updatePersModel(model);
    }

    public void disengage() {
        this.entity = null;
    }

    public Entity getEntity() {
        return this.entity;
    }

    protected void updatePersModel(Object model) {
        this.updatePersDefaultName();
        this.updatePersSpecifiedName(model);
    }

    protected abstract void updatePersSpecifiedName(Object var1);

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.entity.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.entity.setDefaultName(name);
        }
    }

    protected abstract String defaultName();
}

