/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.util.IMockBean;

public abstract class MockBeanFactory {
    private static final Object[] ARGS = new Object[0];
    private static Method MOCK_GET = null;
    private static Method MOCK_SET = null;
    private static Method MOCK_GET_WITH_PROPERTY = null;
    private static Method MOCK_SET_WITH_PROPERTY = null;
    private static Method MOCK_BEAN_INFO = null;

    static {
        try {
            MOCK_GET = IMockBean.class.getDeclaredMethod("getMockValue", String.class);
            MOCK_SET = IMockBean.class.getDeclaredMethod("setMockValue", String.class, Object.class);
            MOCK_GET_WITH_PROPERTY = IMockBean.class.getDeclaredMethod("getMockValue", PropertyDescriptor.class);
            MOCK_SET_WITH_PROPERTY = IMockBean.class.getDeclaredMethod("setMockValue", PropertyDescriptor.class, Object.class);
            MOCK_BEAN_INFO = IMockBean.class.getDeclaredMethod("getBeanInfo", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> T create(Class<T> type, T sample) {
        try {
            return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type, IMockBean.class}, (InvocationHandler)new MockInvocationHandler(type, sample));
        }
        catch (Exception e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    public static <T, U> T create(Class<T>[] types, T sample) {
        try {
            return (T)Proxy.newProxyInstance(types[0].getClassLoader(), new Class[]{types[0], IMockBean.class}, (InvocationHandler)new MockInvocationHandler(types, sample));
        }
        catch (Exception e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    public static <T> T create(Class<T> type) {
        return MockBeanFactory.create(type, null);
    }

    public static <T> IMockBean createMock(Class<T> type, T sample) {
        return (IMockBean)MockBeanFactory.create(type, sample);
    }

    public static <T> IMockBean createMock(Class<T> type) {
        return MockBeanFactory.create(type, null);
    }

    private static class MockInvocationHandler
    implements InvocationHandler {
        private Map<String, Object> m_propertyValues = new HashMap<String, Object>();
        private Map<Method, String> m_readPropertyMapping = new HashMap<Method, String>();
        private Map<Method, String> m_setPropertyMapping = new HashMap<Method, String>();
        private BeanInfo[] m_infos;

        MockInvocationHandler(Class<?> type, Object sample) throws IntrospectionException {
            this.init(new BeanInfo[]{Introspector.getBeanInfo(type)}, sample);
        }

        MockInvocationHandler(Class<?>[] types, Object sample) throws IntrospectionException {
            ArrayList<BeanInfo> beanInfoList = new ArrayList<BeanInfo>();
            int i = 0;
            while (i < types.length) {
                Class<?> type = types[i];
                beanInfoList.add(Introspector.getBeanInfo(type));
                ++i;
            }
            this.init(beanInfoList.toArray(new BeanInfo[0]), sample);
        }

        void init(BeanInfo[] infos, Object sample) {
            try {
                this.m_infos = infos;
                int i = 0;
                while (i < this.m_infos.length) {
                    BeanInfo info = this.m_infos[i];
                    PropertyDescriptor[] propertyDescriptorArray = info.getPropertyDescriptors();
                    int n = propertyDescriptorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                        String name = descriptor.getName();
                        Method read = descriptor.getReadMethod();
                        if (read != null) {
                            this.m_readPropertyMapping.put(read, name);
                            this.m_propertyValues.put(name, read.invoke(sample, ARGS));
                        }
                        Method write = descriptor.getReadMethod();
                        this.m_setPropertyMapping.put(write, name);
                        ++n2;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new DsfRuntimeException((Throwable)e);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = this.m_readPropertyMapping.get(method);
            if (name != null) {
                return this.m_propertyValues.get(name);
            }
            if (method.equals(MOCK_GET)) {
                return this.m_propertyValues.get(args[0]);
            }
            if (method.equals(MOCK_GET_WITH_PROPERTY)) {
                return this.m_propertyValues.get(((PropertyDescriptor)args[0]).getName());
            }
            if (method.equals(MOCK_SET)) {
                this.m_propertyValues.put((String)args[0], args[1]);
                return null;
            }
            if (method.equals(MOCK_SET_WITH_PROPERTY)) {
                this.m_propertyValues.put(((PropertyDescriptor)args[0]).getName(), args[1]);
                return null;
            }
            if (method.equals(MOCK_BEAN_INFO)) {
                return this.m_infos[0];
            }
            name = this.m_setPropertyMapping.get(method);
            if (name != null) {
                this.m_propertyValues.put(name, args[0]);
                return null;
            }
            return null;
        }
    }
}

