/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMImplementationList;

public class DDOMImplementationList
implements DOMImplementationList,
Iterable<DOMImplementation> {
    private List<DOMImplementation> m_impls = new ArrayList<DOMImplementation>();

    public DDOMImplementationList(DOMImplementation ... impls) {
        DOMImplementation[] dOMImplementationArray = impls;
        int n = impls.length;
        int n2 = 0;
        while (n2 < n) {
            DOMImplementation impl = dOMImplementationArray[n2];
            this.add(impl);
            ++n2;
        }
    }

    public DDOMImplementationList(Collection<DOMImplementation> impls) {
        for (DOMImplementation impl : impls) {
            this.add(impl);
        }
    }

    @Override
    public int getLength() {
        return this.m_impls.size();
    }

    @Override
    public DOMImplementation item(int index) {
        try {
            return this.m_impls.get(index);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public Iterator<DOMImplementation> iterator() {
        return this.m_impls.listIterator();
    }

    public void add(DOMImplementation impl) {
        if (impl == null) {
            this.chuck("Cannot add a null implementation");
        }
        this.m_impls.add(impl);
    }

    public void add(DOMImplementationList impls) {
        int len = impls.getLength();
        int i = 0;
        while (i < len) {
            this.add(impls.item(i));
            ++i;
        }
    }

    private void chuck(String msg) {
        throw new DsfRuntimeException(msg);
    }
}

