/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.common.DsfVerifierConfig;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.binding.IValueBinding;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.naming.DsfInvalidNameException;
import org.eclipse.vjet.dsf.common.naming.NameStatusCheck;
import org.eclipse.vjet.dsf.common.node.IAttributeMap;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.support.DsfDomNotSupportedRuntimeException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class AttributeMap
implements IAttributeMap,
NamedNodeMap,
Serializable {
    private static final long serialVersionUID = 1171928675580312397L;
    private static final Object[] EMPTY = new Object[0];
    private final DNode m_propertySource;
    final LinkedHashMap<String, DAttr> m_map;
    final DNode m_owner;

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new DsfRuntimeException("Not implemented");
    }

    @Override
    public Set<Map.Entry<String, DAttr>> attrEntrySet() {
        return this.m_map.entrySet();
    }

    @Override
    public void clear() {
        Iterator<Map.Entry<String, DAttr>> iter = this.m_map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, DAttr> entry = iter.next();
            DAttr attr = entry.getValue();
            iter.remove();
            attr.setOwnerElement(null);
        }
    }

    AttributeMap(DElement owner, DNode propSource, int initialSize) {
        this.m_owner = owner;
        this.m_map = new LinkedHashMap(initialSize);
        this.m_propertySource = propSource;
    }

    public boolean hasAttribute(String key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        PropertyDescriptor pd;
        if (key == null) {
            return false;
        }
        if (!(key instanceof String)) {
            this.chuck("containsKey(Object) signature really requires type String");
        }
        if ((pd = this.m_propertySource.getPropertyDescriptor((String)key)) == null) {
            return this.m_map.containsKey(key);
        }
        return false;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> answer = new ArrayList<Object>(this.size());
        for (Map.Entry<String, DAttr> mapEntry : this.m_map.entrySet()) {
            DAttr attr = mapEntry.getValue();
            answer.add(attr.getObjectValue());
        }
        return answer;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<String, DAttr> mapEntry : this.m_map.entrySet()) {
            Object attrValue;
            DAttr attr = mapEntry.getValue();
            if (!(value == null ? attr.getObjectValue() == null : value.equals(attrValue = attr.getObjectValue()))) continue;
            return true;
        }
        return false;
    }

    public Iterator<String> getKeys() {
        return new Iterator<String>(){
            Iterator<String> backingItr;
            {
                this.backingItr = AttributeMap.this.m_map.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.backingItr.hasNext();
            }

            @Override
            public String next() {
                return this.backingItr.next();
            }

            @Override
            public void remove() {
                throw new DsfRuntimeException("Not supported operation");
            }
        };
    }

    public DAttr getAttributeNode(String key) {
        return this.m_map.get(key);
    }

    DAttr put(DAttr attr) {
        if (attr == null) {
            throw new DOMException(3, "null node is not allowed");
        }
        attr.setOwnerElement((DElement)this.m_owner);
        return this.m_map.put(attr.getNodeName(), attr);
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        DAttr attr = this.m_map.get(key);
        if (attr != null) {
            return attr.getObjectValue();
        }
        PropertyDescriptor pd = this.m_propertySource.getPropertyDescriptor((String)key);
        if (pd == null) {
            return null;
        }
        IValueBinding<?> binding = this.m_propertySource.getIntrinsicPropertyValueBinding((String)key);
        if (binding != null) {
            return binding.getValue();
        }
        Method readMethod = pd.getReadMethod();
        if (readMethod == null) {
            throw new DsfRuntimeException("no read method for " + key);
        }
        try {
            return readMethod.invoke((Object)this.m_propertySource, EMPTY);
        }
        catch (Exception e) {
            throw new DsfRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new DsfRuntimeException("Attribute key must not be null");
        }
        if (value instanceof Attr) {
            throw new DsfRuntimeException("value cannot be an Attr");
        }
        this.assertAttributeName(key);
        this.m_propertySource.assertAttributeRelationship(this.m_propertySource, key, value);
        PropertyDescriptor pd = this.m_propertySource.getPropertyDescriptor(key);
        if (pd == null) {
            Object existing;
            DAttr attr = this.m_map.get(key);
            Object object = existing = attr == null ? null : attr.getObjectValue();
            if (attr == null) {
                attr = new DAttr(this.m_owner.getDsfOwnerDocument(), key);
                this.put(attr);
            }
            attr.setObjectValue(value);
            return existing;
        }
        IValueBinding<?> binding = this.m_propertySource.getIntrinsicPropertyValueBinding(key);
        if (binding != null) {
            Object previous = binding.getValue();
            binding.setValue(value);
            return previous;
        }
        try {
            Method writeMethod;
            Object result = null;
            Method readMethod = pd.getReadMethod();
            if (readMethod != null) {
                result = readMethod.invoke((Object)this.m_propertySource, EMPTY);
            }
            if ((writeMethod = pd.getWriteMethod()) == null) {
                throw new DsfRuntimeException("no write method for " + key);
            }
            writeMethod.invoke((Object)this.m_propertySource, value);
            return result;
        }
        catch (Exception e) {
            throw new DsfRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Object remove(Object key) {
        PropertyDescriptor pd;
        if (key == null) {
            return null;
        }
        if (!(key instanceof String)) {
            this.chuck("remove(Object) signature really requires type String");
        }
        if ((pd = this.m_propertySource.getPropertyDescriptor((String)key)) != null) {
            throw new DsfRuntimeException("Can not remove an intrinsic property");
        }
        DAttr attr = (DAttr)this.m_map.remove(key);
        if (attr == null) {
            return null;
        }
        return attr.getObjectValue();
    }

    @Override
    public IValueBinding getValueBinding(String name) {
        PropertyDescriptor pd = this.m_propertySource.getPropertyDescriptor(name);
        if (pd == null) {
            DAttr attr = this.m_map.get(name);
            if (attr == null) {
                return null;
            }
            return attr.getValueBinding();
        }
        return this.m_propertySource.getIntrinsicPropertyValueBinding(name);
    }

    @Override
    public IValueBinding setValueBinding(String name, IValueBinding binding) {
        if (name == null) {
            throw new DsfRuntimeException("Binding name must not be null");
        }
        PropertyDescriptor pd = this.m_propertySource.getPropertyDescriptor(name);
        if (pd == null) {
            DAttr attr = this.m_map.get(name);
            if (attr == null) {
                if (binding == null) {
                    return null;
                }
                attr = new DAttr(this.m_owner.getDsfOwnerDocument(), name);
                this.put(attr);
            }
            return attr.setValueBinding(binding);
        }
        IValueBinding<?> previousBinding = this.m_propertySource.getIntrinsicPropertyValueBinding(name);
        if (previousBinding != null) {
            this.m_propertySource.setDsfIntrinsicPropertyValueBinding(name, binding);
            return previousBinding;
        }
        throw new DsfRuntimeException("The intrinsic property " + name + " is not bindable");
    }

    @Override
    public Node getNamedItem(String name) {
        DAttr attr = this.getAttributeNode(name);
        return attr;
    }

    @Override
    public Node setNamedItem(Node node) throws DOMException {
        if (!(node instanceof Attr)) {
            throw new DOMException(3, "Expected an Attr type");
        }
        return this.put((DAttr)node);
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        DAttr removedAttr = this.getAttributeNode(name);
        if (removedAttr == null) {
            throw new DOMException(8, "Did not find a node named: " + name);
        }
        this.m_map.remove(name);
        removedAttr.setOwnerElement(null);
        return removedAttr;
    }

    @Override
    public Node item(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        int count = 0;
        for (Map.Entry<String, DAttr> mapEntry : this.m_map.entrySet()) {
            if (count == index) {
                return mapEntry.getValue();
            }
            ++count;
        }
        throw new DsfRuntimeException("assertion failed: size changed after initial inspection");
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        throw new DsfDomNotSupportedRuntimeException("getNamedItemNS(...)");
    }

    @Override
    public Node setNamedItemNS(Node arg) throws DOMException {
        throw new DsfDomNotSupportedRuntimeException("setNamedItemNS(...)");
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        throw new DsfDomNotSupportedRuntimeException("removeNamedItemNS(...)");
    }

    @Override
    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    @Override
    public Set<String> keySet() {
        return this.m_map.keySet();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return null;
    }

    @Override
    public DAttr getAttr(String key) {
        return this.m_map.get(key);
    }

    @Override
    public Iterator<DAttr> iterator() {
        return this.m_map.values().iterator();
    }

    public String toString() {
        Z z = new Z();
        z.getBuffer().append("{");
        for (DAttr attr : this) {
            z.format(attr.getName(), (Object)attr.getValue());
        }
        z.getBuffer().append("}");
        return z.toString();
    }

    private void chuck(String msg) {
        throw new DsfRuntimeException(msg);
    }

    private void assertAttributeName(String name) throws DsfInvalidNameException {
        if (!DsfVerifierConfig.getInstance().isVerifyNaming()) {
            return;
        }
        NameStatusCheck status = this.m_owner.getDsfNamingFamily().verifyLocalName(name);
        if (!status.isOk()) {
            throw new DsfInvalidNameException(status.getErrorMessage());
        }
    }
}

