/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.vjet.dsf.DSFRootAnchor;
import org.eclipse.vjet.dsf.common.trace.IInstrumentDElement;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.html.dom.util.ISelfRender;
import org.w3c.dom.Node;

public class DefaultNodeInstrumenter
implements IInstrumentDElement {
    @Override
    public void startElement(DElement node, IXmlStreamWriter writer) {
        if (!node.getClass().getName().startsWith(DSFRootAnchor.class.getPackage().getName()) || node.getClass().getSimpleName().equals("InvisibleContainer")) {
            node.setAttribute("spycmpname", node.getClass().getName());
            String classAttr = node.getAttribute("class");
            node.setAttribute("class", String.valueOf(classAttr) + " spyCmpBorder");
            String specName = this.getCompSpecName(node);
            if (specName.length() > 0) {
                node.setAttribute("spyspec", specName);
            }
        }
    }

    @Override
    public void setAttributeValue(DElement node, DAttr attr, String value) {
    }

    private String getCompSpecName(DElement node) {
        Class<?>[] clz = node.getClass().getInterfaces();
        int i = 0;
        while (i < clz.length) {
            if (clz[i].getSimpleName().equals("ISpecBasedComponent")) {
                Class[] parameterTypes = new Class[]{};
                try {
                    Method getSpecMethod = node.getClass().getMethod("getCompSpec", parameterTypes);
                    Object[] arguments = new Object[]{};
                    Object spec = getSpecMethod.invoke((Object)node, arguments);
                    return spec.getClass().getName();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return "";
                }
                catch (IllegalAccessException illegalAccessException) {
                    return "";
                }
                catch (InvocationTargetException invocationTargetException) {
                    return "";
                }
            }
            ++i;
        }
        return "";
    }

    @Override
    public void endElement(DElement node, IXmlStreamWriter writer) {
    }

    @Override
    public void startSelfRender(DElement node, IXmlStreamWriter writer) {
        String spyDataModelId;
        if (node.getClass().getName().equals("org.eclipse.vjet.dsf.resource.content.runtime.DContent") || node.getClass().getName().equals("com.ebay.darwin.component.core.page.BasePage")) {
            return;
        }
        if (node.getNodeName().equalsIgnoreCase("BasePage")) {
            return;
        }
        writer.writeStartElement("span");
        writer.writeAttribute("spycmpname", node.getClass().getName());
        writer.writeAttribute("class", "spyCmpBorder");
        writer.writeAttribute("spyAt", node.getAttribute("spyAt"));
        String specName = this.getCompSpecName(node);
        if (specName.length() > 0) {
            writer.writeAttribute("spyspec", specName);
        }
        if ((spyDataModelId = node.getAttribute("spydatamodelid")) != null && !"".equals(spyDataModelId)) {
            writer.writeAttribute("spydatamodelid", spyDataModelId);
        }
    }

    @Override
    public void endSelfRender(DElement node, IXmlStreamWriter writer) {
        if (node.getClass().getName().equals("org.eclipse.vjet.dsf.resource.content.runtime.DContent") || node.getClass().getName().equals("com.ebay.darwin.component.core.page.BasePage")) {
            return;
        }
        if (node.getNodeName().equalsIgnoreCase("BasePage")) {
            return;
        }
        writer.writeEndElement();
    }

    @Override
    public void appendElement(Node parent, Node node) {
        if (node == null) {
            return;
        }
        if (!node.getClass().getName().startsWith(DSFRootAnchor.class.getPackage().getName()) || node instanceof ISelfRender) {
            if (node.getClass().getName().equals("org.eclipse.vjet.dsf.resource.content.runtime.DContent")) {
                return;
            }
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            if (trace.length > 5) {
                for (int caller = 5; caller < trace.length; ++caller) {
                    if (trace[caller].getClassName().startsWith("org.eclipse.vjet.dsf.")) {
                        continue;
                    }
                    if (node instanceof DElement) {
                        DElement de = (DElement)node;
                        de.setAttribute("spyAt", String.valueOf(trace[caller].getClassName()) + ":" + trace[caller].getLineNumber());
                    }
                    return;
                }
            }
        }
    }
}

