/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.trace.IContentTrace;

public class ContentTracker {
    private Map<String, Integer> m_traceback = new HashMap<String, Integer>();
    private static final String BEGIN_INS = "<@#";
    private static final String END_INS = "#@>";

    public ContentTracker(Map<String, Integer> contentMap) {
        this.m_traceback = contentMap;
    }

    public Map<String, Integer> getTraceBackMap() {
        return this.m_traceback;
    }

    private Integer addToTrackbackMap(String text, String id, String instrument) {
        String key;
        if ((text = ContentTracker.replaceDblQuoteAndPipe(text)).length() > 20) {
            text = String.valueOf(text.substring(0, 20)) + "...";
        }
        if (this.m_traceback.containsKey(key = String.valueOf(text) + "|" + id + "|" + instrument)) {
            return this.m_traceback.get(key);
        }
        this.m_traceback.put(key, this.m_traceback.size());
        return this.m_traceback.get(key);
    }

    public String instrumentPlainText(String text, String id, Object contentUnit) {
        StringBuilder builder = new StringBuilder();
        Integer idx = this.addToTrackbackMap(text, id, String.valueOf(contentUnit.getClass().getName()) + "." + id);
        builder.append(text).append(BEGIN_INS).append(idx).append(END_INS);
        return builder.toString();
    }

    public void instrumentDContent(IContentTrace dcontent, String text, String id, Object contentUnit) {
        Integer idx = this.addToTrackbackMap(text, id, String.valueOf(contentUnit.getClass().getName()) + "." + id);
        dcontent.setContentInstrumentation(String.valueOf(idx.toString()) + " ");
    }

    private static String replaceDblQuoteAndPipe(String text) {
        String newtxt = text.replaceAll("\"", "'");
        return newtxt.replace("|", "/");
    }

    public static InstrumentedText[] getAllTracebacks(String value) {
        ArrayList<Integer> startIndexs = new ArrayList<Integer>();
        ArrayList<Integer> endIndexs = new ArrayList<Integer>();
        int startIdx = 0;
        int endIdx = 0;
        int current = 0;
        while (startIdx >= 0 && endIdx >= 0) {
            startIdx = value.indexOf(BEGIN_INS, endIdx);
            if (startIdx < 0) continue;
            startIndexs.add(startIdx);
            endIdx = value.indexOf(END_INS, startIdx);
            if (endIdx >= 0) {
                endIndexs.add(endIdx);
                ++current;
                continue;
            }
            startIndexs.remove(current);
        }
        if (startIndexs.size() == 0) {
            return new InstrumentedText[0];
        }
        InstrumentedText[] instrumentedTexts = new InstrumentedText[startIndexs.size() + 1];
        int begin = 0;
        int beginoffset = BEGIN_INS.length();
        int endoffset = END_INS.length();
        int i = 0;
        i = 0;
        while (i < startIndexs.size()) {
            String text = value.substring(begin, (Integer)startIndexs.get(i));
            String idxStr = value.substring((Integer)startIndexs.get(i) + beginoffset, (Integer)endIndexs.get(i));
            idxStr = ContentTracker.removeNonDigitChars(idxStr);
            int idx = Integer.parseInt(idxStr);
            instrumentedTexts[i] = new InstrumentedText(text, idx);
            begin = (Integer)endIndexs.get(i) + endoffset;
            ++i;
        }
        instrumentedTexts[i] = new InstrumentedText(value.substring(begin), -1);
        return instrumentedTexts;
    }

    private static String removeNonDigitChars(String str) {
        char[] charArray = str.toCharArray();
        int newidx = 0;
        int idx = 0;
        while (idx < charArray.length) {
            char ch = charArray[idx];
            if (ch >= '0' && ch <= '9') {
                if (newidx < idx) {
                    charArray[newidx] = charArray[idx];
                }
                ++newidx;
            }
            ++idx;
        }
        if (newidx == charArray.length) {
            return str;
        }
        char[] newArray = new char[newidx];
        System.arraycopy(charArray, 0, newArray, 0, newidx);
        return new String(newArray);
    }

    public static class InstrumentedText {
        private String m_text;
        private Integer m_traceIdx;

        private InstrumentedText(String text, Integer idx) {
            this.m_text = text;
            this.m_traceIdx = idx;
        }

        public String getText() {
            return this.m_text;
        }

        public Integer getIdx() {
            return this.m_traceIdx;
        }
    }
}

