/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.schemas;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.schemas.IElementInfo;
import org.eclipse.vjet.dsf.html.schemas.ISchema;

public class SchemaImp
implements ISchema,
Iterable<IElementInfo> {
    private final Map<HtmlTypeEnum, IElementInfo> m_elementMap;
    private final IElementInfo[] m_elementInfo;

    private static IElementInfo[] createElementInfoArray(Map<HtmlTypeEnum, IElementInfo> elementMap) {
        int size = HtmlTypeEnum.size();
        IElementInfo[] array = new IElementInfo[size];
        for (HtmlTypeEnum htmlTypeEnum : HtmlTypeEnum.valueIterable()) {
            IElementInfo elementInfo;
            array[htmlTypeEnum.getId()] = elementInfo = elementMap.get(htmlTypeEnum);
        }
        return array;
    }

    public SchemaImp(Map<HtmlTypeEnum, IElementInfo> elementMap) {
        this.m_elementMap = elementMap;
        this.m_elementInfo = SchemaImp.createElementInfoArray(elementMap);
    }

    @Override
    public IElementInfo getElementInfo(HtmlTypeEnum type) {
        if (type == null) {
            return null;
        }
        IElementInfo elementInfo = this.m_elementInfo[type.getId()];
        return elementInfo;
    }

    @Override
    public Iterator<IElementInfo> iterator() {
        return this.m_elementMap.values().iterator();
    }
}

