/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.schemas;

import java.util.Iterator;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.schemas.AttributeInfoMapImpl;
import org.eclipse.vjet.dsf.html.schemas.IAttributeInfo;
import org.eclipse.vjet.dsf.html.schemas.IAttributeInfoMap;
import org.eclipse.vjet.dsf.html.schemas.IContentModel;
import org.eclipse.vjet.dsf.html.schemas.IElementInfo;

public class ElementInfo
implements IElementInfo {
    private final HtmlTypeEnum m_type;
    private final boolean m_requireStartTag;
    private final boolean m_requireEndTag;
    private final IContentModel m_contentModel;
    private final IAttributeInfoMap m_attributeInfo;

    public ElementInfo(HtmlTypeEnum type, IAttributeInfoMap attributeInfoMap, IContentModel contentModel) {
        this(type, attributeInfoMap, contentModel, true, true);
    }

    public ElementInfo(HtmlTypeEnum type, IAttributeInfoMap attributeInfoMap, IContentModel contentModel, boolean requireStartTag, boolean requireEndTag) {
        this.m_type = type;
        this.m_attributeInfo = AttributeInfoMapImpl.createUnmodifiable(attributeInfoMap);
        this.m_requireStartTag = requireStartTag;
        this.m_requireEndTag = requireEndTag;
        this.m_contentModel = contentModel;
    }

    @Override
    public HtmlTypeEnum getType() {
        return this.m_type;
    }

    @Override
    public boolean requireEndTag() {
        return this.m_requireEndTag;
    }

    @Override
    public boolean requireStartTag() {
        return this.m_requireStartTag;
    }

    @Override
    public IAttributeInfo getAttributeInfo(String name) {
        return this.m_attributeInfo.get(name);
    }

    @Override
    public IContentModel getContentModel() {
        return this.m_contentModel;
    }

    @Override
    public Iterator<IAttributeInfo> iterator() {
        return this.m_attributeInfo.iterator();
    }
}

