/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.events;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.events.DsfEventTarget;
import org.eclipse.vjet.dsf.html.events.IDomEventType;

public final class InlineEventHandlerContainer {
    private Map<DsfEventTarget, List<EventsToHandlerPair>> m_targets;

    public void add(BaseHtmlElement elem, IDomEventType event, String handler) {
        DsfEventTarget target = this.getTarget(elem);
        if (target == null) {
            target = new DsfEventTarget();
            target.setElem(elem);
        }
        this.add(target, event, handler);
    }

    private DsfEventTarget getTarget(BaseHtmlElement elem) {
        Iterator<DsfEventTarget> iter = this.getElements().keySet().iterator();
        DsfEventTarget target = null;
        while (iter.hasNext()) {
            DsfEventTarget tmp = iter.next();
            if (tmp.getElem() == null || !tmp.getElem().equals((Object)elem)) continue;
            target = tmp;
            break;
        }
        return target;
    }

    private EventsToHandlerPair getPair(DsfEventTarget elem, IDomEventType eventType) {
        List<EventsToHandlerPair> list = this.getElements().get(elem);
        for (EventsToHandlerPair pair : list) {
            if (pair.getEventType() != eventType) continue;
            return pair;
        }
        return null;
    }

    private void replacePair(DsfEventTarget elem, EventsToHandlerPair oldPair, EventsToHandlerPair newPair) {
        List<EventsToHandlerPair> list = this.getElements().get(elem);
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).equals(oldPair)) {
                list.set(i, newPair);
            }
            ++i;
        }
    }

    private void add(DsfEventTarget elem, IDomEventType eventType, String handler) {
        EventsToHandlerPair newPair = new EventsToHandlerPair(eventType, handler);
        if (this.getElements().containsKey(elem)) {
            EventsToHandlerPair pair = this.getPair(elem, eventType);
            if (pair == null) {
                this.getElements().get(elem).add(newPair);
            } else {
                this.replacePair(elem, pair, newPair);
            }
        } else {
            ArrayList<EventsToHandlerPair> pairs = new ArrayList<EventsToHandlerPair>(3);
            pairs.add(newPair);
            this.getElements().put(elem, pairs);
        }
    }

    public int size() {
        if (this.m_targets == null) {
            return 0;
        }
        return this.m_targets.size();
    }

    public void reset() {
        this.m_targets = null;
    }

    public Iterable<EventsToHandlerPair> iterable(BaseHtmlElement elem) {
        return this.getElements().get(this.getTarget(elem));
    }

    public Map<DsfEventTarget, List<EventsToHandlerPair>> getElements() {
        if (this.m_targets == null) {
            this.m_targets = new LinkedHashMap<DsfEventTarget, List<EventsToHandlerPair>>(0);
        }
        return this.m_targets;
    }

    public String toString() {
        if (this.getElements().isEmpty()) {
            return "No event handlers for this element";
        }
        StringBuilder buffer = new StringBuilder();
        return buffer.toString();
    }

    public static class EventsToHandlerPair {
        private final IDomEventType m_eventType;
        private final String m_handler;

        public EventsToHandlerPair(IDomEventType event, String handler) {
            this.m_eventType = event;
            this.m_handler = handler;
        }

        public IDomEventType getEventType() {
            return this.m_eventType;
        }

        public String getHandler() {
            return this.m_handler;
        }
    }
}

