/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.common.xml.XmlStreamException;
import org.eclipse.vjet.dsf.common.xml.XmlStreamWriter;
import org.eclipse.vjet.dsf.dom.DDocumentType;
import org.eclipse.vjet.dsf.html.HtmlWriterCtx;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocType;
import org.eclipse.vjet.dsf.html.dom.util.IHtmlStreamWriter;
import org.w3c.dom.DocumentType;

public class HtmlStreamWriter
extends XmlStreamWriter
implements IHtmlStreamWriter {
    private final char[][] m_notEscapeTagsChar;
    private final String[] m_notEscapeTags;
    private static final String DOC_START = "<?";
    private static final String XML_10 = "xml version=\"1.0";
    private static final String ENCODE = "\" encoding=\"";
    private static final String DOC_END = "\"?>\r\n";
    private static final String XML_11 = "<?xml version=\"1.1";
    private static String s_defaultDocTypeString;

    static {
        DHtmlDocType tempDocType = DHtmlDocType.createDocType(null, DHtmlDocType.HTML_STRICT);
        StringWriter w = new StringWriter(100);
        tempDocType.write(w);
        s_defaultDocTypeString = w.toString();
    }

    public HtmlStreamWriter(Writer writer) {
        this(writer, (IIndenter)new IIndenter.Pretty());
    }

    public HtmlStreamWriter(Writer writer, IIndenter indenter) {
        this(new HtmlWriterCtx(writer, indenter));
    }

    public HtmlStreamWriter(HtmlWriterCtx options) {
        super(options.getWriter(), options.getIndenter());
        this.m_notEscapeTagsChar = options.getNotEscapeTags();
        int len = this.m_notEscapeTagsChar.length;
        this.m_notEscapeTags = new String[len];
        int i = 0;
        while (i < this.m_notEscapeTagsChar.length) {
            this.m_notEscapeTags[i] = new String(this.m_notEscapeTagsChar[i]);
            ++i;
        }
    }

    @Override
    public void ignoreCurrentEndTag() {
        int size = this.m_tagStack.size();
        this.m_tagStack.remove(size - 1);
        this.closeStartTagIfNecessary();
    }

    public void writeStartDocument(DocumentType doctype) {
        if (doctype == null) {
            try {
                this.m_writer.write(s_defaultDocTypeString);
            }
            catch (IOException e) {
                throw new DsfRuntimeException((Throwable)e);
            }
        } else {
            ((DDocumentType)doctype).write(this.m_writer);
        }
    }

    public void writeStartDocument(String encoding, String version) throws XmlStreamException {
        if (encoding == null && version == null) {
            return;
        }
        StringBuilder tmp = new StringBuilder();
        tmp.append(DOC_START);
        if (version != null) {
            tmp.append(version.equals("1.0") ? XML_10 : XML_11);
        }
        if (encoding != null) {
            tmp.append(ENCODE).append(encoding);
        }
        tmp.append(DOC_END);
        this.writeRaw(tmp.toString());
    }

    public void writeStartDocument(String version) throws XmlStreamException {
        this.writeStartDocument(null, version);
    }

    public void writeCharacters(char[] text, int start, int len) throws XmlStreamException {
        if (this.shouldSkipEscaping()) {
            try {
                this.closeStartTagIfNecessary();
                this.m_writer.write(text, start, len);
            }
            catch (IOException e) {
                throw new XmlStreamException((Exception)e);
            }
        } else {
            super.writeCharacters(text, start, len);
        }
    }

    public void writeCharacters(String text) throws XmlStreamException {
        if (this.shouldSkipEscaping()) {
            this.writeRaw(text);
        } else {
            super.writeCharacters(text);
        }
    }

    private boolean shouldSkipEscaping() {
        if (this.m_tagStack.size() <= 0) {
            return false;
        }
        String currentTagName = this.getCurrentTagName();
        int i = 0;
        while (i < this.m_notEscapeTags.length) {
            if (currentTagName.equals(this.m_notEscapeTags[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void writeEndElement() throws XmlStreamException {
        String tagName = (String)this.m_tagStack.remove(this.m_tagStack.size() - 1);
        try {
            this.closeStartTagIfNecessary();
            this.m_indenter.indent(this.m_writer, this.m_tagStack.size());
            this.m_writer.write(LT_SLASH_CHARS);
            this.m_writer.write(tagName);
            this.m_writer.write(SINGLE_GT_CHARS);
        }
        catch (IOException e) {
            throw new XmlStreamException((Exception)e);
        }
    }
}

