/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import javax.xml.parsers.DocumentBuilder;
import org.ccil.cowan.tagsoup.Parser;
import org.eclipse.vjet.dsf.common.FileUtils;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DDOMImplementationRegistry;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.util.HtmlBuilder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DHtmlDocumentBuilder
extends DocumentBuilder {
    public static DHtmlDocument getDocument(String html) {
        return DHtmlDocumentBuilder.getDocument(new StringBufferInputStream(html));
    }

    public static DHtmlDocument getDocument(Class<?> anchor, String resourceHtml) {
        return DHtmlDocumentBuilder.getDocument(FileUtils.getResourceString(anchor, (String)resourceHtml));
    }

    public static DHtmlDocument getDocument(InputStream inputStream) {
        DHtmlDocumentBuilder builder = new DHtmlDocumentBuilder();
        try {
            return (DHtmlDocument)((Object)builder.parse(inputStream));
        }
        catch (Exception e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        DDOMImplementationRegistry reg = DDOMImplementationRegistry.newInstance();
        DOMImplementation impl = reg.getDOMImplementation("html");
        return impl;
    }

    @Override
    public Document newDocument() {
        return new DHtmlDocument();
    }

    @Override
    public Document parse(InputSource is) throws SAXException, IOException {
        try {
            Parser parser = new Parser();
            HtmlBuilder builder = new HtmlBuilder();
            parser.setContentHandler((ContentHandler)builder);
            parser.parse(is);
            return builder.getHTMLDocument();
        }
        catch (Exception e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isNamespaceAware() {
        return false;
    }

    @Override
    public boolean isValidating() {
        return false;
    }

    @Override
    public void setEntityResolver(EntityResolver er) {
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
    }
}

