/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.BaseAttrsHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DHtmlCollection;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DTBody;
import org.eclipse.vjet.dsf.html.dom.DTFoot;
import org.eclipse.vjet.dsf.html.dom.DTHead;
import org.eclipse.vjet.dsf.html.dom.DTr;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.dom.Util;
import org.w3c.dom.Node;

public abstract class BaseTableSection
extends BaseAttrsHtmlElement {
    private static final long serialVersionUID = 3257001042984973618L;
    private DHtmlCollection m_rows;

    BaseTableSection(HtmlTypeEnum type) {
        super(type);
    }

    BaseTableSection(DHtmlDocument doc, HtmlTypeEnum type) {
        super(doc, type);
    }

    public String getHtmlAlign() {
        return this.capitalize(this.getHtmlAttribute(EHtmlAttr.align));
    }

    public BaseTableSection setHtmlAlign(String align) {
        this.setHtmlAttribute(EHtmlAttr.align, align);
        return this;
    }

    public String getHtmlCh() {
        return Util.getHtmlCh(this);
    }

    public BaseTableSection setHtmlCh(String _char) {
        Util.setHtmlCh(this, _char);
        return this;
    }

    public String getHtmlChOff() {
        return this.getHtmlAttribute(EHtmlAttr.charoff);
    }

    public BaseTableSection setHtmlChOff(String charoff) {
        this.setHtmlAttribute(EHtmlAttr.charoff, charoff);
        return this;
    }

    public String getHtmlValign() {
        return this.capitalize(this.getHtmlAttribute(EHtmlAttr.valign));
    }

    public BaseTableSection setHtmlValign(String valign) {
        this.setHtmlAttribute(EHtmlAttr.valign, valign);
        return this;
    }

    public DHtmlCollection getHtmlRows() {
        if (this.m_rows == null) {
            this.m_rows = new DHtmlCollection(this, 7);
        }
        return this.m_rows;
    }

    public DTr htmlInsertRow(int index) {
        DTr newRow = new DTr();
        newRow.htmlInsertCell(0);
        if (this.insertRowX(index, newRow) >= 0) {
            this.add((DNode)newRow);
        }
        return newRow;
    }

    int insertRowX(int index, DTr newRow) {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof DTr) {
                if (index == 0) {
                    this.insertBefore((Node)((Object)newRow), child);
                    return -1;
                }
                --index;
            }
            child = child.getNextSibling();
        }
        return index;
    }

    public void htmlDeleteRow(int index) {
        this.deleteRowX(index);
    }

    int deleteRowX(int index) {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof DTr) {
                if (index == 0) {
                    this.removeChild(child);
                    return -1;
                }
                --index;
            }
            child = child.getNextSibling();
        }
        return index;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + Z.fmt((String)"align", (Object)this.getHtmlAlign()) + Z.fmt((String)"char", (Object)this.getHtmlCh()) + Z.fmt((String)"charoff", (Object)this.getHtmlChOff()) + Z.fmt((String)"isTableBody", (Object)("" + this.isHtmlTableBody())) + Z.fmt((String)"isTableFooter", (Object)("" + this.isHtmlTableFooter())) + Z.fmt((String)"isTableHeader", (Object)("" + this.isHtmlTableHeader())) + Z.fmt((String)"valign", (Object)this.getHtmlValign());
    }

    public Object clone() throws CloneNotSupportedException {
        BaseTableSection clonedNode = (BaseTableSection)((Object)super.clone());
        clonedNode.m_rows = null;
        return clonedNode;
    }

    public boolean isHtmlTableHeader() {
        return this instanceof DTHead;
    }

    public boolean isHtmlTableFooter() {
        return this instanceof DTFoot;
    }

    public boolean isHtmlTableBody() {
        return this instanceof DTBody;
    }
}

