/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.node.IAttributeMap;
import org.eclipse.vjet.dsf.common.trace.TraceCtx;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.util.DomToRawSaxGenerator;
import org.eclipse.vjet.dsf.dom.util.DomToRawSaxTraceGenerator;
import org.eclipse.vjet.dsf.html.HtmlWriterCtx;
import org.eclipse.vjet.dsf.html.dom.util.HtmlStreamWriter;
import org.eclipse.vjet.dsf.html.dom.util.HtmlWriter;
import org.eclipse.vjet.dsf.html.dom.util.IRawSaxHandler;
import org.eclipse.vjet.dsf.html.schemas.ISchema;
import org.w3c.dom.Node;

public class HtmlWriterHelper {
    public static String asString(Node node) {
        Writer sw = HtmlWriterCtx.createWriter();
        HtmlWriterHelper.write(node, sw);
        return sw.toString();
    }

    public static String asPrettyString(Node node) {
        return HtmlWriterHelper.asString(node, (IIndenter)new IIndenter.Pretty());
    }

    public static String asString(Node node, HtmlWriterCtx writerOpt) {
        HtmlWriterHelper.write(node, writerOpt);
        return writerOpt.getWriter().toString();
    }

    public static String asString(Node node, IIndenter indenter) {
        StringWriter sw = new StringWriter();
        HtmlWriterHelper.write(node, new HtmlWriterCtx(sw, indenter));
        return sw.toString();
    }

    public static void write(Node node, Writer writer) {
        HtmlWriterHelper.write(node, new HtmlWriterCtx(writer));
    }

    public static void write(Node node, Writer writer, IIndenter indenter) {
        HtmlWriterCtx opts = new HtmlWriterCtx(writer, indenter);
        HtmlWriterHelper.write(node, opts);
    }

    public static void write(Node node, Writer writer, IIndenter indenter, ISchema schema) {
        HtmlWriterCtx opts = new HtmlWriterCtx(writer, indenter, schema);
        HtmlWriterHelper.write(node, opts);
    }

    public static void write(Node node, HtmlWriterCtx ctx) {
        HtmlStreamWriter writer = new HtmlStreamWriter(ctx);
        HtmlWriter rawSaxHandler = new HtmlWriter(writer, ctx);
        boolean haveInstrumenter = TraceCtx.ctx().haveInstrumenter();
        DomToRawSaxTraceGenerator saxGenerator = haveInstrumenter ? new DomToRawSaxTraceGenerator((IRawSaxHandler)rawSaxHandler) : new DomToRawSaxGenerator((IRawSaxHandler)rawSaxHandler);
        try {
            saxGenerator.genEvents(node, (IXmlStreamWriter)writer);
        }
        catch (Exception e) {
            throw new DsfRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] asBytes(Node node, String encoding, IIndenter indenter) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)baos, encoding);
        HtmlWriterHelper.write(node, w, indenter);
        return baos.toByteArray();
    }

    public static byte[] asBytes(Node node, String encoding, IIndenter indenter, ISchema schema) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)baos, encoding);
        HtmlWriterHelper.write(node, w, indenter, schema);
        return baos.toByteArray();
    }

    public static String asOneLineString(DNode node) {
        StringWriter sw = new StringWriter();
        HtmlStreamWriter writer = new HtmlStreamWriter(sw, IIndenter.COMPACT);
        writer.writeStartElement(node.getNodeName());
        IAttributeMap attrs = node.getDsfAttributes();
        for (DAttr attr : attrs) {
            writer.writeAttribute(attr.getNodeName(), attr.getValue());
        }
        return String.valueOf(sw.toString()) + ">";
    }
}

