/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace;

import org.eclipse.vjet.af.common.types.RawString;
import org.eclipse.vjet.dsf.DSFRootAnchor;
import org.eclipse.vjet.dsf.common.trace.ContentTraceInfo;
import org.eclipse.vjet.dsf.common.trace.ContentTracker;
import org.eclipse.vjet.dsf.common.trace.IContentTrace;
import org.eclipse.vjet.dsf.common.trace.IInstrumentDElement;
import org.eclipse.vjet.dsf.common.trace.TraceCtx;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DRawString;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.html.dom.DScript;
import org.eclipse.vjet.dsf.html.dom.DSelect;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class ContentTraceInstrumenter
implements IInstrumentDElement {
    public void appendElement(Node parent, Node child) {
        if (parent.getClass().getName().startsWith(DSFRootAnchor.class.getPackage().getName())) {
            if (parent.getNodeType() != 1) {
                return;
            }
            String value = null;
            StringBuilder spyTr = new StringBuilder(100);
            String text = null;
            DElement de = (DElement)parent;
            String instrument = null;
            if (child instanceof DText) {
                value = child instanceof DRawString ? ((DRawString)child).getRawString().getString() : child.getNodeValue();
                if (value != null && value.length() > 0) {
                    StringBuilder childSpyTr = new StringBuilder(100);
                    text = this.buildSpyTrace(value, childSpyTr);
                    if (childSpyTr.length() > 0) {
                        if (child instanceof DRawString) {
                            ((DRawString)child).setRawString(new RawString(text));
                        } else {
                            child.setNodeValue(text);
                        }
                    }
                    de = (DElement)parent;
                    String parentAttr = ((DElement)parent).getAttribute("spyTr");
                    String childAttr = childSpyTr.toString();
                    spyTr.append(parentAttr).append(childAttr);
                    instrument = childAttr;
                }
            } else if (child instanceof IContentTrace) {
                de = (DElement)parent;
                String traceIdx = ((IContentTrace)child).getContentInstrumentation();
                if (traceIdx == null) {
                    traceIdx = "";
                }
                String parentAttr = ((DElement)parent).getAttribute("spyTr");
                spyTr.append(parentAttr).append(traceIdx);
                instrument = traceIdx;
            } else if (parent instanceof DSelect && child instanceof DElement) {
                String childAttr = ((DElement)child).getAttribute("spyTr");
                String parentAttr = ((DElement)parent).getAttribute("spyTr");
                spyTr.append(parentAttr).append(childAttr);
                de = (DElement)parent;
                instrument = childAttr;
            }
            if (de != null && !(de instanceof DScript)) {
                String attr = "";
                if (spyTr.length() > 0) {
                    attr = spyTr.toString().trim();
                }
                if (attr.length() > 0) {
                    de.setAttribute("spyTr", String.valueOf(attr) + " ");
                    this.setContentTraceTextInstrumentInfo(de, instrument);
                }
            }
        }
    }

    public void setAttributeValue(DElement node, DAttr attr, String value) {
        if (value != null && value.length() > 0) {
            StringBuilder attrTr = new StringBuilder(100);
            String text = this.buildSpyTrace(value, attrTr);
            if (attrTr.length() > 0) {
                attr.setOldValue(text);
                if (node != null && !(node instanceof DScript)) {
                    StringBuilder spyTr = new StringBuilder(100);
                    String spyAttr = attrTr.toString();
                    String parentAttr = node.getAttribute("spyTr");
                    if (this.findDuplicateTr(parentAttr, spyAttr)) {
                        spyTr.append(parentAttr);
                    } else {
                        spyTr.append(parentAttr).append(spyAttr);
                    }
                    node.setAttribute("spyTr", String.valueOf(spyTr.toString().trim()) + " ");
                    this.setContentTraceAttributeInstrumentInfo(node, attr, spyAttr);
                }
            }
        }
    }

    private boolean findDuplicateTr(String parentSpyTr, String attrSpyTr) {
        if (parentSpyTr == null || parentSpyTr.length() == 0) {
            return false;
        }
        String[] parent = parentSpyTr.split(" ");
        String[] attrTr = attrSpyTr.split(" ");
        int i = 0;
        while (i < parent.length) {
            if (parent[i].equals(attrTr[0])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setContentTraceAttributeInstrumentInfo(DElement element, DAttr attr, String instrument) {
        DAttr attrNode = this.getContentTraceAttrNode(element);
        ContentTraceInfo cti = (ContentTraceInfo)attrNode.getObjectValue();
        cti.setAttributeInstrument(attr.getName(), instrument);
    }

    private void setContentTraceTextInstrumentInfo(DElement element, String instrument) {
        DAttr attrNode = this.getContentTraceAttrNode(element);
        ContentTraceInfo cti = (ContentTraceInfo)attrNode.getObjectValue();
        cti.setTextInstrument(instrument);
    }

    private DAttr getContentTraceAttrNode(DElement element) {
        Attr attr = element.getAttributeNode("ContentTr_V4cid");
        if (attr == null) {
            DAttr attrNode = new DAttr("ContentTr_V4cid", "empty");
            ContentTraceInfo cti = new ContentTraceInfo();
            attrNode.setObjectValue((Object)cti);
            element.setAttributeNode((Attr)attrNode);
            return attrNode;
        }
        return (DAttr)attr;
    }

    private String buildSpyTrace(String instrumentedString, StringBuilder spyTr) {
        ContentTracker.InstrumentedText[] instrumentedTexts = ContentTracker.getAllTracebacks((String)instrumentedString);
        if (instrumentedTexts.length > 0) {
            StringBuilder builder = new StringBuilder(100);
            int i = 0;
            while (i < instrumentedTexts.length) {
                builder.append(instrumentedTexts[i].getText());
                Integer idx = instrumentedTexts[i].getIdx();
                if (idx != null && idx >= 0) {
                    spyTr.append(idx).append(" ");
                }
                ++i;
            }
            return builder.toString();
        }
        return instrumentedString;
    }

    public void startSelfRender(DElement node, IXmlStreamWriter writer) {
        String id = node.getAttribute("id");
        if (id != null && id.equals("SpyglassTracebackTbl")) {
            this.generateContentTracebackTable(node);
        }
    }

    public void endSelfRender(DElement node, IXmlStreamWriter writer) {
    }

    private void generateContentTracebackTable(DElement node) {
        ContentTracker tracker;
        boolean hasContentTracker = TraceCtx.ctx().haveContentTracker();
        if (hasContentTracker && (tracker = TraceCtx.ctx().getContentTracker()).getTraceBackMap().size() > 0) {
            String[] localList = new String[tracker.getTraceBackMap().size()];
            for (Object key : tracker.getTraceBackMap().keySet()) {
                localList[((Integer)tracker.getTraceBackMap().get(key)).intValue()] = (String)key;
            }
            StringBuffer sbuf = new StringBuffer("var spyglassTracebackTbl = [ ");
            String[] stringArray = localList;
            int n = localList.length;
            int n2 = 0;
            while (n2 < n) {
                String trace = stringArray[n2];
                sbuf.append("\"").append(trace).append("\",\n");
                ++n2;
            }
            sbuf.append("\"\" ]");
            node.add(sbuf.toString());
        }
    }

    public void startElement(DElement node, IXmlStreamWriter writer) {
        Object value;
        DAttr attr = (DAttr)node.getAttributeNode("ContentTr_V4cid");
        if (attr != null && (value = attr.getObjectValue()) != null && value instanceof ContentTraceInfo) {
            ContentTraceInfo cti = (ContentTraceInfo)value;
            attr.setObjectValue(null);
            StringBuilder spyTr = new StringBuilder(100);
            String attrList = cti.getAttrInsList();
            String textList = cti.getTextInsList();
            spyTr.append("{NS:").append(cti.getNameSpace()).append(", attr {").append(attrList).append("}, ").append("text [").append(textList).append("]}");
            attr.setValue(spyTr.toString());
        }
    }

    public void endElement(DElement node, IXmlStreamWriter writer) {
    }
}

