/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dervlet.embedded.server;

import java.io.Serializable;

public class EmbeddedServerConfig
implements Serializable,
Cloneable {
    static final long serialVersionUID = 2080280717058448646L;
    private int m_port;
    private int m_originalPort;
    private String m_contextPath;
    private String m_resourceBase;
    private boolean m_sslEnabled = false;
    private int m_sslPort = 8443;
    private String m_sslKeystore = null;
    private String m_keystoreType = "jks";
    private String m_sslPassword = null;
    private boolean m_isProxy = false;
    private String m_sslKeyPassword = null;
    private String m_protocol = null;
    private boolean m_enableSession = true;
    private String m_truststore = null;
    private String m_truststoreType = "jks";
    private boolean m_requireClientAuth = false;
    private String m_sslTrustPassword = null;
    private final ClassLoader m_classLoader;

    public EmbeddedServerConfig(int port, String contextPath, String resourceBase) {
        this(port, contextPath, resourceBase, null);
    }

    public EmbeddedServerConfig(int port, String contextPath, String resourceBase, ClassLoader classLoader) {
        if (port < 0) {
            throw new RuntimeException("Port must be a positive integer");
        }
        this.m_originalPort = this.m_port = port;
        this.m_contextPath = contextPath == null ? "/" : contextPath;
        this.m_resourceBase = resourceBase == null ? "." : resourceBase;
        this.m_classLoader = classLoader;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getContextPath() {
        return this.m_contextPath;
    }

    public String getResourceBase() {
        return this.m_resourceBase;
    }

    public boolean isProxy() {
        return this.m_isProxy;
    }

    public EmbeddedServerConfig setPort(int port) {
        this.m_port = port;
        return this;
    }

    EmbeddedServerConfig resetPort(int port) {
        this.m_originalPort = this.m_port = port;
        return this;
    }

    public int getOriginalPort() {
        return this.m_originalPort;
    }

    EmbeddedServerConfig setContextPath(String path) {
        this.m_contextPath = path;
        return this;
    }

    EmbeddedServerConfig setResourceBase(String base) {
        this.m_resourceBase = base;
        return this;
    }

    ClassLoader getContextClassLoader() {
        return this.m_classLoader;
    }

    public String toString() {
        String NL = System.getProperty("line.separator");
        StringBuilder buf = new StringBuilder();
        buf.append("Port").append(": ").append(this.m_port).append(NL);
        buf.append("Context Path").append(": ").append(this.m_contextPath).append(NL);
        buf.append("Resource Base").append(": ").append(this.m_resourceBase).append(NL);
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof EmbeddedServerConfig)) {
            return false;
        }
        EmbeddedServerConfig other = (EmbeddedServerConfig)o;
        return this.getPort() == other.getPort();
    }

    public int getSslPort() {
        return this.m_sslPort;
    }

    public void setSslPort(int port) {
        this.m_sslPort = port;
    }

    public String getSslKeystore() {
        return this.m_sslKeystore;
    }

    public void setSslKeystore(String keystore) {
        this.m_sslKeystore = keystore;
    }

    public void setKeystoreType(String keystoreType) {
        this.m_keystoreType = keystoreType;
    }

    public String getKeystoreType() {
        return this.m_keystoreType;
    }

    public String getSslTruststore() {
        return this.m_truststore;
    }

    public void setSslTruststore(String truststore) {
        this.m_truststore = truststore;
    }

    public void setTruststoreType(String truststoreType) {
        this.m_truststoreType = truststoreType;
    }

    public String getTruststoreType() {
        return this.m_truststoreType;
    }

    public String getSslPassword() {
        return this.m_sslPassword;
    }

    public void setSslPassword(String password) {
        this.m_sslPassword = password;
    }

    public String getSslTrustPassword() {
        return this.m_sslTrustPassword;
    }

    public void setSslTrustPassword(String password) {
        this.m_sslTrustPassword = password;
    }

    public void setSslEnabled(boolean flag) {
        this.m_sslEnabled = flag;
    }

    public boolean getSslEnabled() {
        return this.m_sslEnabled;
    }

    public String getSslKeyPassword() {
        return this.m_sslKeyPassword;
    }

    public void setSslKeyPassword(String password) {
        this.m_sslKeyPassword = password;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public void setProtocol(String protocol) {
        this.m_protocol = protocol;
    }

    public boolean isEnableSession() {
        return this.m_enableSession;
    }

    public void setEnableSession(boolean set) {
        this.m_enableSession = set;
    }

    public boolean isRequireClientAuth() {
        return this.m_requireClientAuth;
    }

    public void setRequireClientAuth(boolean set) {
        this.m_requireClientAuth = set;
    }
}

