/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dervlet;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapIntercepter;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.DBody;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.util.NodeToDHtmlDocument;
import org.eclipse.vjet.vsf.aggregator.view.DocProcessor;
import org.eclipse.vjet.vsf.dervlet.BrowserManager;
import org.eclipse.vjet.vsf.dervlet.CoreDervlet;
import org.eclipse.vjet.vsf.dervlet.DsfDervletUtil;
import org.eclipse.vjet.vsf.dervlet.dap.DapEnabler;
import org.eclipse.vjet.vsf.dervlet.embedded.server.EmbeddedServer;
import org.eclipse.vjet.vsf.docprocessing.ProductionCtx;
import org.w3c.dom.Node;

public class DsfDervlet
extends CoreDervlet {
    private static final long serialVersionUID = 1L;
    private IIndenter m_indenter = IIndenter.COMPACT;
    private DapEnabler m_dapEnabler = null;
    private DapIntercepter m_dapIntercepter = null;
    private List<DsfDervlet> m_dependents;

    public DsfDervlet() {
        this((String)null, (String)null);
    }

    public DsfDervlet(String name) {
        this(name, (String)null);
    }

    public DsfDervlet(String name, Map<String, String> defaultUrlParameters) {
        this(name);
        this.m_defaultUrlParameters.putAll(defaultUrlParameters);
    }

    public DsfDervlet(String name, String path) {
        super(name, path);
        String host = EmbeddedServer.getLocalHostName(80);
        DapCtx.ExeMode dapMode = DapCtx.ExeMode.WEB;
        String dapEnv = System.getProperty("dapMode");
        if ("A".equalsIgnoreCase(dapEnv)) {
            dapMode = DapCtx.ExeMode.ACTIVE;
        } else if ("T".equalsIgnoreCase(dapEnv)) {
            dapMode = DapCtx.ExeMode.TRANSLATE;
        }
        this.m_dapIntercepter = new DapIntercepter(host, dapMode);
    }

    public void init() throws ServletException {
    }

    public DsfDervlet(String name, String path, Map<String, String> defaultUrlParameters) {
        this(name, path);
        this.m_defaultUrlParameters.putAll(defaultUrlParameters);
    }

    public void setDapMode(DapCtx.ExeMode mode) {
        this.m_dapIntercepter.setDapMode(mode);
    }

    public void setIndenter(IIndenter indenter) {
        this.m_indenter = indenter;
    }

    public DapIntercepter getDapIntercepter() {
        return this.m_dapIntercepter;
    }

    @Override
    public void runAsServer() {
        final DsfDervlet dervlet = this;
        new BaseDervletApp(){

            @Override
            protected void init() {
                this.setEntryURL(dervlet.getPath());
                this.addDervlet(dervlet);
                if (DsfDervlet.this.m_dependents != null) {
                    for (DsfDervlet dervlet2 : DsfDervlet.this.m_dependents) {
                        this.addDervlet(dervlet2);
                    }
                }
                this.start();
            }
        };
    }

    public void addDependentDervlet(DsfDervlet dependent) {
        if (this.m_dependents == null) {
            this.m_dependents = new ArrayList<DsfDervlet>();
        } else if (this.m_dependents.contains(dependent)) {
            return;
        }
        this.m_dependents.add(dependent);
    }

    public void addDependentServlet(Servlet dependent, String name, String path) {
        if (this.m_dependents == null) {
            this.m_dependents = new ArrayList<DsfDervlet>();
        }
        this.m_dependents.add(new ServletWrapper(dependent, name, path));
    }

    public List<DsfDervlet> getDependentDervlets() {
        if (this.m_dependents == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_dependents);
    }

    protected DNode createFragment() {
        DBody body = new DBody();
        body.add("default fraglet text, servlet name:" + this.getServletName());
        return body;
    }

    protected DNode createFragment(HttpServletRequest request) {
        return this.createFragment();
    }

    @Override
    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.setupCtx(request);
        this.handleDapRequest(request, response);
        this.clearCache();
        this.handleRequest(request, response);
        ProductionCtx.ctx().reset();
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        DNode node = this.createFragment(request);
        this.displayFragment(node, request, response);
    }

    protected void handleDapRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.getServer() != null) {
            this.m_dapIntercepter.getDapConfig().setPort(this.getServer().getPort());
        }
        if (DapCtx.ctx().isActiveMode()) {
            if (this.m_dapEnabler == null) {
                this.m_dapEnabler = new DapEnabler(this.m_dapIntercepter);
                this.m_dapEnabler.enable();
            }
            this.m_dapEnabler.handleRequest(request, response);
        }
    }

    protected void setupCtx(HttpServletRequest request) {
    }

    protected void clearCache() {
        if (!DsfDervlet.needDebug()) {
            return;
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected static boolean needDebug() {
        RuntimeMXBean rtMxBean = ManagementFactory.getRuntimeMXBean();
        for (String arg : rtMxBean.getInputArguments()) {
            if (!arg.startsWith("-agentlib:jdwp")) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected void displayFragment(DNode node, HttpServletResponse response) throws IOException {
        DHtmlDocument doc = NodeToDHtmlDocument.createHtmlDocumentContaining((Node)node, (boolean)false);
        if (!(node instanceof DHtmlDocument)) {
            new DocProcessor(ProductionCtx.ctx().getPlan()).process(doc);
        }
    }

    protected void displayFragment(DNode node, HttpServletRequest request, HttpServletResponse response) throws IOException {
        DHtmlDocument doc = NodeToDHtmlDocument.createHtmlDocumentContaining((Node)node, (boolean)false);
        if (!(node instanceof DHtmlDocument)) {
            new DocProcessor(ProductionCtx.ctx().getPlan()).process(doc);
        }
        this.m_dapIntercepter.handleResponse(request, response, doc, this.m_indenter);
    }

    public static abstract class BaseDervletApp {
        protected static EmbeddedServer s_server = BaseDervletApp.createServer();
        protected List<CoreDervlet> m_dervlets = new ArrayList<CoreDervlet>(5);
        private String m_entryURL;

        private static EmbeddedServer createServer() {
            EmbeddedServer server = DsfDervletUtil.getInstance().create();
            server.start();
            return server;
        }

        protected BaseDervletApp() {
            this.init();
        }

        protected abstract void init();

        public BaseDervletApp start() {
            assert (this.m_entryURL != null);
            for (CoreDervlet dervlet : this.m_dervlets) {
                s_server.addDervlet(dervlet);
            }
            String url = String.valueOf(s_server.getBaseUrl()) + this.m_entryURL;
            if (!"prod".equals(System.getProperty("mode"))) {
                BrowserManager.displayUrlInDefault(url);
            }
            return this;
        }

        public List<CoreDervlet> getDervlets() {
            return this.m_dervlets;
        }

        public BaseDervletApp addDervlet(CoreDervlet dervlet) {
            this.m_dervlets.add(dervlet);
            return this;
        }

        public String getEntryURL() {
            return this.m_entryURL;
        }

        public BaseDervletApp setEntryURL(String entryURL) {
            this.m_entryURL = entryURL;
            return this;
        }
    }

    public static class ServletWrapper
    extends DsfDervlet {
        private Servlet m_servlet;
        private String m_name;
        private String m_path;

        ServletWrapper(Servlet servlet, String name, String path) {
            this.m_servlet = servlet;
            this.m_name = name;
            this.m_path = path;
        }

        public Servlet getServlet() {
            return this.m_servlet;
        }

        public String getName() {
            return this.m_name;
        }

        @Override
        public String getPath() {
            return this.m_path;
        }
    }
}

