/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dervlet;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.vjet.dsf.common.FileUtils;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.dsf.dap.rt.DapBrowserBridge;
import org.eclipse.vjet.dsf.dap.rt.DapCaptureReplay;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.IDapConsoleHandler;
import org.eclipse.vjet.dsf.dom.DNode;

public class DapConsoleJUnitCodeGenHandler
implements IDapConsoleHandler {
    public static final String GEN_JUNIT = "GEN_JUNIT";
    public static final String DUMP_TEST_CAPTURE = "DUMP_TEST_CAPTURE";
    private static final String[] INPUTS = new String[]{"GEN_JUNIT", "DUMP_TEST_CAPTURE"};
    public static final String SEND = "  SEND -> ";
    public static final String REQUEST = "  REQUEST -> ";
    public static final String RESPONSE = "    RESPONSE -> ";
    private String m_targetPackageRoot = "";
    private String m_targetPackageName = "";

    public String[] getSupportedInputs() {
        return null;
    }

    public void handle(String input) {
        if (GEN_JUNIT.equalsIgnoreCase(input)) {
            System.err.println("GEN_JUNIT has been deprecated. Please use HELP for supported DAP console commands");
        }
    }

    public String getTargetPackageRoot() {
        return this.m_targetPackageRoot;
    }

    public void setTargetPackageRoot(String targetPackageRoot) {
        this.m_targetPackageRoot = targetPackageRoot;
    }

    public String getTargetPackageName() {
        return this.m_targetPackageName;
    }

    public void setTargetPackageName(String targetPackageName) {
        this.m_targetPackageName = targetPackageName;
    }

    private DapCaptureReplay getCaptureReplay() {
        return DapCtx.ctx().getSession().getCaptureReplay();
    }

    private String dumpTestEventCapture() {
        DapCaptureData capturedData = this.getCaptureReplay().getCapturedData();
        if (capturedData == null) {
            System.err.println("capture is not enabled");
            return null;
        }
        String captureInfo = "";
        List list = capturedData.getAllEventCaptures();
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            DapCaptureData.EventCapture capture = (DapCaptureData.EventCapture)itr.next();
            if (capture.getEvent() != null) {
                System.err.print("\"" + capture.getEvent().getPayload().replaceAll("\\\"", "\\\\\""));
                captureInfo = String.valueOf(captureInfo) + "\"" + capture.getEvent().getPayload().replaceAll("\\\"", "\\\\\"");
            }
            System.err.print(" --- ");
            captureInfo = String.valueOf(captureInfo) + " --- ";
            Iterator actionsItr = capture.getActionsIter();
            while (actionsItr.hasNext()) {
                DapCaptureData.IActionInfo info = (DapCaptureData.IActionInfo)actionsItr.next();
                if (info instanceof DapCaptureData.DlcSend) {
                    DapCaptureData.DlcSend sendActionInfo = (DapCaptureData.DlcSend)info;
                    System.err.print(SEND + sendActionInfo.getMessage().replaceAll("\\\"", "\\\\\""));
                    captureInfo = String.valueOf(captureInfo) + SEND + sendActionInfo.getMessage().replaceAll("\\\"", "\\\\\"");
                } else if (info instanceof DapCaptureData.DlcRnR) {
                    DapCaptureData.DlcRnR rnrActionInfo = (DapCaptureData.DlcRnR)info;
                    System.err.print(REQUEST + rnrActionInfo.getRequest().replaceAll("\\\"", "\\\\\""));
                    captureInfo = String.valueOf(captureInfo) + REQUEST + rnrActionInfo.getRequest().replaceAll("\\\"", "\\\\\"");
                    System.err.print(RESPONSE + rnrActionInfo.getResponse().replaceAll("\\\"", "\\\\\""));
                    captureInfo = String.valueOf(captureInfo) + RESPONSE + rnrActionInfo.getResponse().replaceAll("\\\"", "\\\\\"");
                } else {
                    System.err.print("  " + info.toString().replaceAll("\\\"", "\\\\\""));
                    captureInfo = String.valueOf(captureInfo) + "  " + info.toString().replaceAll("\\\"", "\\\\\"");
                }
                System.err.print(" ;;; ");
                System.err.print("\"\n + \"");
                captureInfo = String.valueOf(captureInfo) + " ;;; " + "\"\n + \"";
            }
            if (itr.hasNext()) {
                System.err.print("\", \n");
                captureInfo = String.valueOf(captureInfo) + "\", \n";
                continue;
            }
            System.err.print("\"");
            captureInfo = String.valueOf(captureInfo) + "\"";
            try {
                FileUtils.writeFile((String)"dump_test_capture_output.txt", (String)captureInfo, (String)"UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return captureInfo;
    }

    private void generateJUnitTest(String content) {
        BufferedWriter writer;
        DapCaptureData capturedData = this.getCaptureReplay().getCapturedData();
        if (capturedData == null) {
            System.err.println("capture is not enabled");
            return;
        }
        String pkg = this.m_targetPackageName == null ? "" : this.m_targetPackageName.replace(".", File.separator);
        String targetFullPath = String.valueOf(this.m_targetPackageRoot) + pkg + "JUnit.java";
        String dervletClassName = this.m_targetPackageName.substring(this.m_targetPackageName.lastIndexOf(".") + 1, this.m_targetPackageName.length());
        String tempPath = DapConsoleJUnitCodeGenHandler.classLocation(DapBrowserBridge.class).replace("bin", "src");
        String templatePath = tempPath.substring(0, tempPath.lastIndexOf("\\") + 1);
        ArrayList<String> testCandidates = new ArrayList<String>();
        String methodName = "";
        try {
            Method[] methods = Class.forName(this.m_targetPackageName).getDeclaredMethods();
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (DapConsoleJUnitCodeGenHandler.isExtendedFromDNode(m.getReturnType()) && Modifier.isPublic(m.getModifiers())) {
                    methodName = m.toGenericString();
                    if (Modifier.isStatic(m.getModifiers())) {
                        methodName = methodName.substring(methodName.lastIndexOf(".") + 1);
                        testCandidates.add(String.valueOf(dervletClassName) + "." + methodName);
                    } else {
                        methodName = methodName.substring(methodName.lastIndexOf(".") + 1);
                        testCandidates.add("new " + dervletClassName + "()." + methodName);
                    }
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException cne) {
            cne.printStackTrace();
        }
        try {
            String cfr_ignored_0 = String.valueOf(this.m_targetPackageRoot) + pkg + "AjaxInfo.txt";
            writer = null;
            List list = capturedData.getAllEventCaptures();
            list.iterator();
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            writer = new BufferedWriter(new FileWriter(targetFullPath, false));
            BufferedReader reader = new BufferedReader(new FileReader(String.valueOf(templatePath) + "JUnitTemplate.txt"));
            String tempLine = null;
            while ((tempLine = reader.readLine()) != null) {
                if (tempLine.contains("packageName")) {
                    writer.write(tempLine.replace("packageName", this.m_targetPackageName.substring(0, this.m_targetPackageName.lastIndexOf("."))));
                    writer.newLine();
                    continue;
                }
                if (tempLine.contains("JUnitTestClassName")) {
                    writer.write(tempLine.replace("JUnitTestClassName", String.valueOf(dervletClassName) + "JUnit"));
                    writer.newLine();
                    continue;
                }
                if (tempLine.contains("Messages")) {
                    writer.write(tempLine.replace("Messages", content));
                    writer.newLine();
                    continue;
                }
                if (testCandidates.size() > 0) {
                    if (tempLine.contains("NodeToBeTest")) {
                        writer.write(tempLine.replace("NodeToBeTest", (CharSequence)testCandidates.get(0)));
                        writer.newLine();
                        if (testCandidates.size() <= 1) continue;
                        System.err.print("\n\n\n");
                        System.err.println("--- Found multiple test candidates in your Dervlet ---");
                        for (String s : testCandidates) {
                            System.err.println(s);
                        }
                        System.err.println("Will use [" + (String)testCandidates.get(0) + "] as test node. \n");
                        continue;
                    }
                    if (tempLine.contains("testSample")) {
                        writer.write(tempLine.replace("testSample()", "test_" + ((String)testCandidates.get(0)).substring(((String)testCandidates.get(0)).lastIndexOf(".") + 1)));
                        continue;
                    }
                }
                writer.write(tempLine);
                writer.newLine();
            }
            reader.close();
            writer.close();
            System.out.println("\n\n--- JUnit test file based on Dervlet [ " + dervletClassName + " ] is generated --- ");
            System.out.println("Location: " + targetFullPath + "\n");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    static String classLocation(Class<?> cls) {
        String s;
        int index;
        String name = cls.getName().replace(".", "/");
        URL loc = cls.getResource("/" + name + ".class");
        File f = new File(loc.getFile());
        if (f.getPath().startsWith("file:") && (index = (s = f.getPath()).indexOf("!")) != -1) {
            f = new File(s.substring(5).replace("!", File.separator));
            return f.getPath();
        }
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        return f.getPath();
    }

    private static boolean isExtendedFromDNode(Class<?> c) {
        while (c.getSuperclass() != null) {
            if (c.equals(DNode.class)) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }
}

