/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.js;

import java.util.HashMap;
import org.eclipse.vjet.dsf.html.js.IJsObjectRef;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlotAssignment;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlotter;
import org.eclipse.vjet.dsf.spec.collector.ResourceSpecCollector;
import org.eclipse.vjet.dsf.spec.resource.IResourceSpec;
import org.eclipse.vjet.vjo.bootstrap.VjBootstrap;
import org.eclipse.vjet.vsf.FirePageLoadJsr;
import org.eclipse.vjet.vsf.error.ErrorHandlerManagerJsr;
import org.eclipse.vjet.vsf.jsref.JsFunc;
import org.eclipse.vjet.vsf.jsruntime.context.JsRuntimeCtx;
import org.eclipse.vjet.vsf.jsruntime.error.IErrorHandler;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceRef;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResource;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResourceProxy;
import org.eclipse.vjet.vsf.resource.pattern.js.JsType;
import org.eclipse.vjet.vsf.resource.pattern.js.OnFlyJsResourceDispenser;

public class JsProcessorUtils
extends OnFlyJsResourceDispenser {
    public static final String ERROR_HANDLER_PREFIX = "_ERROR_";

    public static void addJsErrorHandling(JsResourceSlotter slotter) {
        String[] slotsOrder = slotter.getSlotsOrder();
        HashMap<String, Integer> slotsMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < slotsOrder.length) {
            slotsMap.put(slotsOrder[i], i);
            ++i;
        }
        JsResourceSlotAssignment slotAssignment = new JsResourceSlotAssignment();
        IJsResourceRef resDef = JsProcessorUtils.jsRef(JsResource.viaText((String)"", (String)ERROR_HANDLER_PREFIX), JsType.DefOnly);
        IJsResourceRef resExec = JsProcessorUtils.jsRef(JsResource.viaText((String)"", (String)ERROR_HANDLER_PREFIX), JsType.ExecutionOnly);
        String errorHandlerMgrSlot = slotter.getPreAssignedSlot(resDef, resDef.getUrn(), slotter.getDefaultSlotName());
        String errorHandlerMgrSlotDefExtended = JsResourceSlotter.getSlotName((String)errorHandlerMgrSlot, (JsType)resDef.getType());
        String errorHandlerMgrSlotExecExtended = JsResourceSlotter.getSlotName((String)errorHandlerMgrSlot, (JsType)resExec.getType());
        for (IErrorHandler errorHandler : JsRuntimeCtx.ctx().getErrorHandlers()) {
            ResourceSpecCollector specCollector2 = new ResourceSpecCollector();
            specCollector2.aggregate((IResourceSpec)errorHandler.getJsResource());
            for (IResourceSpec spec : specCollector2) {
                String errorHandlerSlotExtended;
                String errorHandlerSlot;
                for (IJsResourceRef resource : spec.getClassDefinitions()) {
                    errorHandlerSlot = slotter.getPreAssignedSlot(resource, resource.getResource().getUrn(), slotter.getDefaultSlotName());
                    errorHandlerSlotExtended = JsResourceSlotter.getSlotName((String)errorHandlerSlot, (JsType)resource.getType());
                    if (((Integer)slotsMap.get(errorHandlerSlotExtended)).compareTo((Integer)slotsMap.get(errorHandlerMgrSlotDefExtended)) <= 0) continue;
                    slotAssignment.put(resource, errorHandlerMgrSlot);
                }
                for (IJsResourceRef resource : spec.getExecutingScript()) {
                    errorHandlerSlot = slotter.getPreAssignedSlot(resource, resource.getResource().getUrn(), slotter.getDefaultSlotName());
                    errorHandlerSlotExtended = JsResourceSlotter.getSlotName((String)errorHandlerSlot, (JsType)resource.getType());
                    if (((Integer)slotsMap.get(errorHandlerSlotExtended)).compareTo((Integer)slotsMap.get(errorHandlerMgrSlotExecExtended)) <= 0) continue;
                    slotAssignment.put(resource, errorHandlerMgrSlot);
                }
            }
            IJsObjectRef jsObj = errorHandler.getJsObj();
            JsFunc jsFunc = ErrorHandlerManagerJsr.register((Object)jsObj);
            String reg = String.valueOf(jsFunc.getScope()) + "." + jsFunc.getName() + "(" + jsObj.getInstantiationJs() + ");";
            JsResource registration = JsResource.viaText((String)reg, null);
            JsResourceProxy registrationProxy = new JsResourceProxy(registration, ERROR_HANDLER_PREFIX + registration.getUrn());
            slotter.addToSlot(JsProcessorUtils.jsRef((JsResource)registrationProxy, JsType.ExecutionOnly));
            JsRuntimeCtx.ctx().getCompRegistry().remove(jsObj);
        }
        slotter.addSlotAssignment(slotAssignment);
    }

    public static void enableWindowOnError(JsResourceSlotter slotter, boolean hideJsErrors) {
        JsProcessorUtils.enableWindowOnError(slotter, hideJsErrors, false);
    }

    public static void enableWindowOnError(JsResourceSlotter slotter, boolean hideJsErrors, boolean captureJsStackTrace) {
        IJsResourceRef res = JsProcessorUtils.jsRef(JsResource.viaText((String)ErrorHandlerManagerJsr.enableOnError((boolean)hideJsErrors, (boolean)captureJsStackTrace).genInvocationJs(false), (String)(ERROR_HANDLER_PREFIX + ErrorHandlerManagerJsr.class.getName())), JsType.ExecutionOnly);
        slotter.addToSlot(res);
    }

    public static void addVjBootstrap(JsResourceSlotter slotter) {
        slotter.addToSlot(VjBootstrap.ResourceSpec.REF);
    }

    public static void addPageLoadTrigger(JsResourceSlotter slotter) {
        slotter.addToSlot(JsProcessorUtils.jsRef(FirePageLoadJsr.ResourceSpec.RESOURCE, JsType.ExecutionOnly));
    }

    private static IJsResourceRef jsRef(JsResource resource, JsType type) {
        return JsProcessorUtils.jsRef((JsResource)resource, JsProcessorUtils.class, (JsType)type);
    }
}

