/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.liveconnect.driver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.DBody;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.liveconnect.DLCDispatcher;
import org.eclipse.vjet.dsf.liveconnect.DLCHttpRequest;
import org.eclipse.vjet.dsf.liveconnect.DLCHttpResponse;
import org.eclipse.vjet.dsf.liveconnect.DLCServer;
import org.eclipse.vjet.dsf.liveconnect.IDLCReceiver;
import org.eclipse.vjet.dsf.liveconnect.client.DLCClientHelper;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCClient;

public class SimpleConsoleDriver
implements IDLCReceiver {
    protected DLCDispatcher m_dlcDispatcher;
    protected int m_dlcPort;
    protected DLCServer m_server;
    protected IDLCClient m_dlcClient;
    private SysInThread m_sysInThread;
    public static final String INSERT_DLC_SCRIPT = "function insertDlc(host,port){var script=document.createElement('script');script.type='text/javascript';script.text=\"var DLC_HOST='\"+host+\"';var DLC_PORT=\"+port+';';document.getElementsByTagName('head')[0].appendChild(script);script=document.createElement('script');script.type='text/javascript';script.src='http://'+host+':'+port+'/DLC_JS.js';div=document.createElement('div');div.id='DLC_OBJ';document.body.appendChild(div);div.appendChild(script);};";
    private static SyncHttpResponse m_syncHttpResponse = new SyncHttpResponse();
    private static final String REQUEST_TOKEN = "REQUEST:";
    private static final String DLC_PORT = "DLC_PORT";

    public SimpleConsoleDriver(IDLCClient dlcClient) {
        try {
            this.m_dlcClient = dlcClient;
            this.m_server = new DLCServer(this, this.m_dlcClient);
            this.m_dlcPort = this.m_server.getPort();
            this.m_dlcDispatcher = new DLCDispatcher(this.m_server);
            this.startSysInHandler();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public DHtmlDocument createDlcEnabledDoc(DNode node, String host) {
        DHtmlDocument doc;
        if (node instanceof DHtmlDocument) {
            doc = (DHtmlDocument)node;
        } else {
            doc = new DHtmlDocument();
            if (node instanceof DBody) {
                doc.add(node);
            } else {
                doc.getBody().add(node);
            }
        }
        DLCClientHelper.enableDLC(host, this.m_dlcPort, doc, this.m_dlcClient);
        return doc;
    }

    public String getDlcInjectionScriptlet(String host) {
        return "javascript:function insertDlc(host,port){var script=document.createElement('script');script.type='text/javascript';script.text=\"var DLC_HOST='\"+host+\"';var DLC_PORT=\"+port+';';document.getElementsByTagName('head')[0].appendChild(script);script=document.createElement('script');script.type='text/javascript';script.src='http://'+host+':'+port+'/DLC_JS.js';div=document.createElement('div');div.id='DLC_OBJ';document.body.appendChild(div);div.appendChild(script);};insertDlc('" + host + "'," + this.m_dlcPort + ");";
    }

    public int getDlcPort() {
        return this.m_dlcPort;
    }

    @Override
    public void closed(SocketChannel channel) {
        this.m_dlcDispatcher.removeChannel(channel);
        System.out.println(channel.socket().getRemoteSocketAddress() + " closed");
    }

    @Override
    public void connected(SocketChannel channel) {
        this.m_dlcDispatcher.addChannel(channel);
        System.out.println("connected from " + channel.socket().getRemoteSocketAddress());
    }

    public void shutdown() {
        if (this.m_sysInThread != null) {
            this.m_sysInThread.m_shutdown = true;
            this.m_sysInThread.interrupt();
        }
        this.m_server.shutdown();
    }

    @Override
    public DLCHttpResponse get(SocketChannel channel, DLCHttpRequest request) {
        String requestData = request.getMessage();
        String responseData = "acknowledged";
        if (requestData != null && requestData.trim().endsWith("?")) {
            if (m_syncHttpResponse.setRequest(request.getMessage(), 30000L)) {
                responseData = m_syncHttpResponse.getResponse();
            } else {
                responseData = m_syncHttpResponse.getResponse();
                if (responseData == null) {
                    responseData = "timeout";
                    System.out.println("timeout");
                }
            }
        } else {
            System.out.println("IN(REQ/AUTO-RESPONSE)-> " + requestData);
        }
        DLCHttpResponse response = new DLCHttpResponse(responseData);
        response.setContentType("text/plain");
        return response;
    }

    @Override
    public void received(SocketChannel channel, String message) {
        System.out.println("IN-> " + message);
    }

    private void startSysInHandler() {
        this.m_sysInThread = new SysInThread(this.m_dlcDispatcher, this.m_dlcPort);
        this.m_sysInThread.start();
    }

    private static class SyncHttpResponse {
        private String m_request = null;
        private String m_response = null;

        private SyncHttpResponse() {
        }

        synchronized String getResponse() {
            this.m_request = null;
            return this.m_response;
        }

        synchronized boolean waitForResponse() {
            return this.m_request != null;
        }

        synchronized void setResponse(String response) {
            this.m_response = response;
            this.notifyAll();
        }

        synchronized boolean setRequest(String request, long timeout) {
            this.m_response = null;
            this.m_request = request;
            System.out.println("IN(REQ)-> " + request);
            System.out.print("OUT(RESP)-> ");
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {}
            return this.m_response != null;
        }
    }

    static class SysInThread
    extends Thread {
        DLCDispatcher m_dispatcher;
        int m_dlcPort;
        boolean m_shutdown = false;

        public SysInThread(DLCDispatcher dispatcher, int dlcPort) {
            this.m_dispatcher = dispatcher;
            this.m_dlcPort = dlcPort;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while (!this.m_shutdown) {
                try {
                    String line = in.readLine();
                    if (line.startsWith(SimpleConsoleDriver.REQUEST_TOKEN)) {
                        String msg = line.substring(SimpleConsoleDriver.REQUEST_TOKEN.length());
                        Iterator<SocketChannel> itr = this.m_dispatcher.getChannels();
                        while (itr.hasNext()) {
                            String response = this.m_dispatcher.request(itr.next(), msg, 1000);
                            System.err.println(response);
                        }
                        continue;
                    }
                    if (line.startsWith(SimpleConsoleDriver.DLC_PORT)) {
                        System.err.println(this.m_dlcPort);
                        continue;
                    }
                    if (m_syncHttpResponse.waitForResponse()) {
                        m_syncHttpResponse.setResponse(line);
                        continue;
                    }
                    this.m_dispatcher.broadcast(line, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

