/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.json.serializer;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.json.serializer.AbstractSerializer;
import org.eclipse.vjet.dsf.json.serializer.ObjectMatch;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.json.serializer.SerializerState;

public class SetSerializer
extends AbstractSerializer {
    private static Class[] s_serializableClasses = new Class[]{Set.class, HashSet.class, TreeSet.class};
    private static Class[] s_JSONClasses = new Class[]{JsonObject.class};

    public Class[] getSerializableClasses() {
        return s_serializableClasses;
    }

    public Class[] getJSONClasses() {
        return s_JSONClasses;
    }

    @Override
    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JsonObject.class) && Set.class.isAssignableFrom(clazz);
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws SerializationException {
        JsonObject jso = (JsonObject)o;
        String java_class = jso.getString("javaClass");
        if (java_class == null) {
            throw new SerializationException("no type hint");
        }
        if (!(java_class.equals("java.util.Set") || java_class.equals("java.util.AbstractSet") || java_class.equals("java.util.TreeSet") || java_class.equals("java.util.HashSet"))) {
            throw new SerializationException("not a Set");
        }
        JsonObject jsonset = jso.getJSONObject("set");
        if (jsonset == null) {
            throw new SerializationException("set missing");
        }
        ObjectMatch m = new ObjectMatch(-1);
        Iterator i = jsonset.keys();
        String key = null;
        try {
            while (i.hasNext()) {
                key = (String)i.next();
                m = this.getOwner().tryUnmarshall(state, null, jsonset.get(key)).max(m);
            }
        }
        catch (SerializationException e) {
            throw new SerializationException("key " + key + " " + e.getMessage());
        }
        return m;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws SerializationException {
        JsonObject jso = (JsonObject)o;
        String java_class = jso.getString("javaClass");
        if (java_class == null) {
            throw new SerializationException("no type hint");
        }
        AbstractSet abset = null;
        if (java_class.equals("java.util.Set") || java_class.equals("java.util.AbstractSet") || java_class.equals("java.util.HashSet")) {
            abset = new HashSet();
        } else if (java_class.equals("java.util.TreeSet")) {
            abset = new TreeSet();
        } else {
            throw new SerializationException("not a Set");
        }
        JsonObject jsonset = jso.getJSONObject("set");
        if (jsonset == null) {
            throw new SerializationException("set missing");
        }
        Iterator i = jsonset.keys();
        String key = null;
        try {
            while (i.hasNext()) {
                key = (String)i.next();
                Object setElement = jsonset.get(key);
                abset.add(this.getOwner().unmarshall(state, null, setElement));
            }
        }
        catch (SerializationException e) {
            throw new SerializationException("key " + i + e.getMessage());
        }
        return abset;
    }

    @Override
    public Object marshall(SerializerState state, Object o) throws SerializationException {
        Set set = (Set)o;
        JsonObject setdata = new JsonObject();
        Object key = null;
        Iterator i = set.iterator();
        try {
            while (i.hasNext()) {
                key = i.next();
                setdata.put(key.toString(), this.getOwner().marshall(state, key));
            }
        }
        catch (SerializationException e) {
            throw new SerializationException("set key " + key + e.getMessage());
        }
        return setdata;
    }
}

