/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.lookup;

import org.eclipse.mod.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CaseStatement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.ProblemReporter;

public class BlockScope
extends Scope {
    public LocalVariableBinding[] locals;
    public int numberMethods;
    public int localIndex;
    public int startIndex;
    public int offset;
    public int maxOffset;
    public BlockScope[] shiftScopes;
    public Scope[] subscopes = new Scope[1];
    public int subscopeCount = 0;
    public CaseStatement enclosingCase;
    public static final VariableBinding[] EmulationPathToImplicitThis = new VariableBinding[0];
    public static final VariableBinding[] NoEnclosingInstanceInConstructorCall = new VariableBinding[0];
    public static final VariableBinding[] NoEnclosingInstanceInStaticContext = new VariableBinding[0];

    public BlockScope(BlockScope parent) {
        this(parent, true);
    }

    public BlockScope(BlockScope parent, boolean addToParentScope) {
        this(1, parent);
        this.locals = new LocalVariableBinding[5];
        if (addToParentScope) {
            parent.addSubscope(this);
        }
        this.startIndex = parent.localIndex;
    }

    public BlockScope(BlockScope parent, int variableCount) {
        this(1, parent);
        this.locals = new LocalVariableBinding[variableCount];
        parent.addSubscope(this);
        this.startIndex = parent.localIndex;
    }

    protected BlockScope(int kind, Scope parent) {
        super(kind, parent);
        this.locals = new LocalVariableBinding[5];
    }

    public void addLocalVariable(LocalVariableBinding binding) {
        int n;
        this.checkAndSetModifiersForVariable(binding);
        if (this.localIndex == this.locals.length) {
            this.locals = new LocalVariableBinding[this.localIndex * 2];
            System.arraycopy(this.locals, 0, this.locals, 0, this.localIndex);
        }
        this.locals[this.localIndex++] = binding;
        binding.declaringScope = this;
        MethodScope outerMostMethodScope = this.outerMostMethodScope();
        if (outerMostMethodScope != null) {
            int n2 = outerMostMethodScope.analysisIndex;
            n = n2;
            outerMostMethodScope.analysisIndex = n2 + 1;
        } else {
            int n3 = this.compilationUnitScope().analysisIndex;
            n = n3;
            this.compilationUnitScope().analysisIndex = n3 + 1;
        }
        binding.id = n;
    }

    public void addSubscope(Scope childScope) {
        if (this.subscopeCount == this.subscopes.length) {
            this.subscopes = new Scope[this.subscopeCount * 2];
            System.arraycopy(this.subscopes, 0, this.subscopes, 0, this.subscopeCount);
        }
        this.subscopes[this.subscopeCount++] = childScope;
    }

    String basicToString(int tab) {
        String newLine = "\n";
        int i = tab;
        while (--i >= 0) {
            newLine = String.valueOf(newLine) + "\t";
        }
        String s = String.valueOf(newLine) + "--- Block Scope ---";
        newLine = String.valueOf(newLine) + "\t";
        s = String.valueOf(s) + newLine + "locals:";
        int i2 = 0;
        while (i2 < this.localIndex) {
            s = String.valueOf(s) + newLine + "\t" + this.locals[i2].toString();
            ++i2;
        }
        s = String.valueOf(s) + newLine + "startIndex = " + this.startIndex;
        return s;
    }

    private void checkAndSetModifiersForVariable(LocalVariableBinding varBinding) {
        int modifiers;
        varBinding.modifiers = modifiers = varBinding.modifiers;
    }

    public void reportUnusedDeclarations() {
        if (this.locals != null) {
            int i = 0;
            while (i < this.localIndex) {
                LocalVariableBinding local = this.locals[i];
                if (local.useFlag == 0 && local.declaration != null && (local.declaration.bits & 0x40000000) != 0 && !(local.declaration instanceof Argument)) {
                    this.problemReporter().unusedLocalVariable(local.declaration);
                }
                ++i;
            }
        }
    }

    public LocalDeclaration[] findLocalVariableDeclarations(int position) {
        int ilocal = 0;
        int maxLocals = this.localIndex;
        boolean hasMoreVariables = maxLocals > 0;
        LocalDeclaration[] localDeclarations = null;
        int declPtr = 0;
        int iscope = 0;
        int maxScopes = this.subscopeCount;
        boolean hasMoreScopes = maxScopes > 0;
        while (hasMoreVariables || hasMoreScopes) {
            LocalDeclaration localDecl;
            if (hasMoreScopes && (!hasMoreVariables || this.subscopes[iscope].startIndex() <= ilocal)) {
                Scope subscope = this.subscopes[iscope];
                if (subscope.kind == 1 && (localDeclarations = ((BlockScope)subscope).findLocalVariableDeclarations(position)) != null) {
                    return localDeclarations;
                }
                hasMoreScopes = ++iscope < maxScopes;
                continue;
            }
            LocalVariableBinding local = this.locals[ilocal];
            if (local != null && (localDecl = local.declaration) != null) {
                if (localDecl.declarationSourceStart <= position) {
                    if (position <= localDecl.declarationSourceEnd) {
                        if (localDeclarations == null) {
                            localDeclarations = new LocalDeclaration[maxLocals];
                        }
                        localDeclarations[declPtr++] = localDecl;
                    }
                } else {
                    return localDeclarations;
                }
            }
            boolean bl = hasMoreVariables = ++ilocal < maxLocals;
            if (hasMoreVariables || localDeclarations == null) continue;
            return localDeclarations;
        }
        return null;
    }

    @Override
    public LocalVariableBinding findVariable(char[] variableName) {
        int varLength = variableName.length;
        int i = this.localIndex - 1;
        while (i >= 0) {
            LocalVariableBinding local = this.locals[i];
            char[] localName = local.name;
            if (local.name.length == varLength && CharOperation.equals(localName, variableName)) {
                return local;
            }
            --i;
        }
        return null;
    }

    public final boolean isDuplicateLocalVariable(char[] name) {
        BlockScope current = this;
        while (true) {
            int i = 0;
            while (i < this.localIndex) {
                if (CharOperation.equals(name, current.locals[i].name)) {
                    return true;
                }
                ++i;
            }
            if (current.kind != 1) {
                return false;
            }
            current = (BlockScope)current.parent;
        }
    }

    public int maxShiftedOffset() {
        int max = -1;
        if (this.shiftScopes != null) {
            int i = 0;
            int length = this.shiftScopes.length;
            while (i < length) {
                int subMaxOffset = this.shiftScopes[i].maxOffset;
                if (subMaxOffset > max) {
                    max = subMaxOffset;
                }
                ++i;
            }
        }
        return max;
    }

    @Override
    public ProblemReporter problemReporter() {
        BlockScope scope = this.outerMostMethodScope();
        if (scope == null) {
            scope = this.compilationUnitScope();
        }
        return ((Scope)scope).problemReporter();
    }

    public TypeDeclaration referenceType() {
        return this.methodScope().referenceType();
    }

    public int scopeIndex() {
        if (this instanceof MethodScope || this instanceof CompilationUnitScope) {
            return -1;
        }
        BlockScope parentScope = (BlockScope)this.parent;
        Scope[] parentSubscopes = parentScope.subscopes;
        int i = 0;
        int max = parentScope.subscopeCount;
        while (i < max) {
            if (parentSubscopes[i] == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    int startIndex() {
        return this.startIndex;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        String s = this.basicToString(tab);
        int i = 0;
        while (i < this.subscopeCount) {
            if (this.subscopes[i] instanceof BlockScope) {
                s = String.valueOf(s) + ((BlockScope)this.subscopes[i]).toString(tab + 1) + "\n";
            }
            ++i;
        }
        return s;
    }
}

