/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.IObjectLiteral;
import org.eclipse.mod.wst.jsdt.core.ast.IObjectLiteralField;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ObjectLiteralField;
import org.eclipse.mod.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;

public class ObjectLiteral
extends Expression
implements IObjectLiteral {
    public ObjectLiteralField[] fields;

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.fields == null || this.fields.length == 0) {
            output.append("{}");
        } else {
            output.append("{\n");
            ObjectLiteral.printIndent(indent + 1, output);
            int i = 0;
            while (i < this.fields.length) {
                if (i > 0) {
                    output.append(",\n");
                    ObjectLiteral.printIndent(indent + 1, output);
                }
                this.fields[i].printExpression(indent, output);
                ++i;
            }
            output.append("\n");
            ObjectLiteral.printIndent(indent, output);
            output.append("}");
        }
        return output;
    }

    @Override
    public IObjectLiteralField[] getFields() {
        return this.fields;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.fields != null) {
            int i = 0;
            while (i < this.fields.length) {
                this.fields[i].traverse(visitor, scope);
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public int nullStatus(FlowInfo flowInfo) {
        return -1;
    }

    @Override
    public int getASTType() {
        return 76;
    }
}

