/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.PreferencesLookupDelegate;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.corext.util.Resources;
import org.eclipse.dltk.mod.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.dltk.mod.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.dltk.mod.internal.ui.editor.ExternalFileEditorInput;
import org.eclipse.dltk.mod.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.internal.ui.editor.ActionMessages;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoEditor;
import org.eclipse.vjet.eclipse.internal.ui.text.CommentFormattingContext;
import org.eclipse.vjet.eclipse.internal.ui.text.CommentFormattingStrategy;
import org.eclipse.vjet.eclipse.internal.ui.text.JavaScriptFormattingStrategy;

public class FormatSourceHandler
extends AbstractHandler {
    private Shell m_shell;
    private DocumentRewriteSession fRewriteSession;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection base = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        this.m_shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
        IWorkbenchPage page = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
        IEditorInput editorInput = page.getActiveEditor().getEditorInput();
        if (base instanceof TextSelection) {
            IWorkbenchPart part = page.getActivePart();
            IModelElement modelElement = null;
            modelElement = editorInput instanceof ExternalFileEditorInput ? ((ExternalFileEditorInput)editorInput).getModelElement() : ((VjoEditor)part).getInputModelElement();
            this.formatElems(new IModelElement[]{modelElement});
        }
        if (base instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)base;
            IModelElement[] elems = this.getCompilationUnits(selection);
            this.formatElems(elems);
            System.out.println("format selection" + selection.getClass());
        }
        return null;
    }

    private void formatElems(IModelElement[] elems) {
        int returnCode;
        if (elems.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.FormatAllAction_EmptySelection_title, (String)ActionMessages.FormatAllAction_EmptySelection_description);
            return;
        }
        if (elems.length != 1 && (returnCode = OptionalMessageDialog.open((String)"FormatAll", (Shell)this.getShell(), (String)ActionMessages.FormatAllAction_noundo_title, null, (String)ActionMessages.FormatAllAction_noundo_message, (int)4, (String[])new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, (int)0)) != 1025 && returnCode != 0) {
            return;
        }
        this.runOnMultiple(elems);
    }

    private IResource[] getResources(IModelElement[] cus) {
        IResource[] res = new IResource[cus.length];
        int i = 0;
        while (i < res.length) {
            res[i] = cus[i].getResource();
            ++i;
        }
        return res;
    }

    public void runOnMultiple(final IModelElement[] cus) {
        try {
            final MultiStatus status = new MultiStatus("org.eclipse.vjet.eclipse.ui", 0, ActionMessages.FormatAllAction_status_description, null);
            IStatus valEditStatus = Resources.makeCommittable((IResource[])this.getResources(cus), (Object)this.getShell());
            if (valEditStatus.matches(8)) {
                return;
            }
            status.merge(valEditStatus);
            if (!status.matches(4)) {
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) {
                        FormatSourceHandler.this.doRunOnMultiple(cus, status, monitor);
                    }
                }));
            }
            if (!status.isOK()) {
                String title = ActionMessages.FormatAllAction_multi_status_title;
                ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)ActionMessages.FormatAllAction_error_title, (String)ActionMessages.FormatAllAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static Map getFomatterSettings(IScriptProject project) {
        Map defaultOptions = VjetPlugin.getOptions();
        PreferencesLookupDelegate context = new PreferencesLookupDelegate(project.getProject());
        String[] propertyNames = new String[defaultOptions.size()];
        propertyNames = defaultOptions.keySet().toArray(propertyNames);
        Hashtable<String, String> projectOptions = new Hashtable<String, String>(propertyNames.length);
        int i = 0;
        while (i < propertyNames.length) {
            String propertyName = propertyNames[i];
            String value = context.getString("org.eclipse.vjet.eclipse.core", propertyName);
            if (value != null && defaultOptions.containsKey(propertyName)) {
                projectOptions.put(propertyName, value.trim());
            }
            ++i;
        }
        return new HashMap(projectOptions);
    }

    private void doRunOnMultiple(IModelElement[] cus, MultiStatus status, IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(ActionMessages.FormatAllAction_operation_description);
        monitor.beginTask("", cus.length * 4);
        try {
            Map lastOptions = null;
            IScriptProject lastProject = null;
            int i = 0;
            while (i < cus.length) {
                IModelElement cu = cus[i];
                IPath path = cu.getPath();
                if (lastProject == null || !lastProject.equals(cu.getScriptProject())) {
                    lastProject = cu.getScriptProject();
                    lastOptions = FormatSourceHandler.getFomatterSettings(lastProject);
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (cu.getResource().getResourceAttributes().isReadOnly()) {
                    String message = Messages.format((String)ActionMessages.FormatAllAction_read_only_skipped, (Object)path.toString());
                    status.add((IStatus)new Status(2, "org.eclipse.vjet.eclipse.ui", 2, message, null));
                } else {
                    ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                    try {
                        try {
                            manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            monitor.subTask(path.makeRelative().toString());
                            ITextFileBuffer fileBuffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
                            this.formatCompilationUnit(fileBuffer, lastOptions);
                            if (fileBuffer.isDirty() && !fileBuffer.isShared()) {
                                fileBuffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 2), false);
                            } else {
                                monitor.worked(2);
                            }
                        }
                        finally {
                            manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    catch (CoreException e) {
                        String message = Messages.format((String)ActionMessages.FormatAllAction_problem_accessing, (Object[])new String[]{path.toString(), e.getLocalizedMessage()});
                        status.add((IStatus)new Status(2, "org.eclipse.vjet.eclipse.ui", 2, message, (Throwable)e));
                    }
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void formatCompilationUnit(final ITextFileBuffer fileBuffer, final Map options) {
        if (fileBuffer.isShared()) {
            this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    FormatSourceHandler.this.doFormat(fileBuffer.getDocument(), options);
                }
            });
        } else {
            this.doFormat(fileBuffer.getDocument(), options);
        }
    }

    private void doFormat(IDocument document, Map options) {
        CommentFormattingContext context = new CommentFormattingContext();
        try {
            context.setProperty("formatting.context.preferences", options);
            context.setProperty("formatting.context.document", true);
            MultiPassContentFormatter formatter = new MultiPassContentFormatter("___java_partitioning", "__dftl_partition_content_type");
            formatter.setMasterStrategy((IFormattingStrategy)new JavaScriptFormattingStrategy());
            formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__javascript_doc");
            formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__javascript_single_comment");
            formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__javascript_multi_comment");
            try {
                this.startSequentialRewriteMode(document);
                formatter.format(document, (IFormattingContext)context);
            }
            finally {
                this.stopSequentialRewriteMode(document);
            }
        }
        finally {
            context.dispose();
        }
    }

    private void startSequentialRewriteMode(IDocument document) {
        if (document instanceof IDocumentExtension4) {
            IDocumentExtension4 extension = (IDocumentExtension4)document;
            this.fRewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        } else if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.startSequentialRewrite(false);
        }
    }

    private void stopSequentialRewriteMode(IDocument document) {
        if (document instanceof IDocumentExtension4) {
            IDocumentExtension4 extension = (IDocumentExtension4)document;
            extension.stopRewriteSession(this.fRewriteSession);
        } else if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.stopSequentialRewrite();
        }
    }

    public Shell getShell() {
        return this.m_shell;
    }

    private IModelElement[] getCompilationUnits(IStructuredSelection selection) {
        HashSet<IModelElement> result = new HashSet<IModelElement>();
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            try {
                IModelElement elem;
                if (selected[i] instanceof IModelElement && (elem = (IModelElement)selected[i]).exists()) {
                    switch (elem.getElementType()) {
                        case 5: 
                        case 7: {
                            result.add(elem);
                            break;
                        }
                        case 4: {
                            this.collectCompilationUnits((IScriptFolder)elem, result);
                            break;
                        }
                        case 3: {
                            this.collectCompilationUnits((IProjectFragment)elem, result);
                            break;
                        }
                        case 2: {
                            IProjectFragment[] roots = ((IScriptProject)elem).getProjectFragments();
                            int k = 0;
                            while (k < roots.length) {
                                this.collectCompilationUnits(roots[k], result);
                                ++k;
                            }
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
            catch (ModelException e) {
                VjetPlugin.error((String)"model exception while collecting items to format", (Throwable)e);
            }
            ++i;
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    private void collectCompilationUnits(IScriptFolder pack, Collection result) throws ModelException {
        result.addAll(Arrays.asList(pack.getChildren()));
    }

    private void collectCompilationUnits(IProjectFragment root, Collection result) throws ModelException {
        if (root.getKind() == 1) {
            IModelElement[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                this.collectCompilationUnits((IProjectFragment)children[i], result);
                ++i;
            }
        }
    }
}

