/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.internal.ui.editor.ExternalFileEditorInput;
import org.eclipse.dltk.mod.internal.ui.editor.IModelElementFileAdivsor;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.vjet.eclipse.internal.ui.editor.NativeElementFileAdvisor;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoEditor;
import org.eclipse.vjet.eclipse.internal.ui.preferences.codestyle.CodeTemplateContextType;
import org.eclipse.vjet.eclipse.internal.ui.preferences.codestyle.CodeTemplates;
import org.eclipse.vjet.eclipse.internal.ui.preferences.codestyle.CompatibilityTemplateStore;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.FormatterProfileStore;
import org.eclipse.vjet.eclipse.internal.ui.text.VjoTextTools;
import org.eclipse.vjet.eclipse.ui.VjetPartListener;
import org.eclipse.vjet.eclipse.ui.VjetPerspectiveListener;
import org.osgi.framework.BundleContext;

public class VjetUIPlugin
extends AbstractUIPlugin
implements IStartup {
    private IPartListener partListener = new VjetPartListener();
    private IPerspectiveListener perspectiveListener = new VjetPerspectiveListener();
    private static VjetUIPlugin s_plugin;
    public static final String PLUGIN_ID = "org.eclipse.vjet.eclipse.ui";
    private TemplateStore fCodeTemplateStore;
    private static final String CODE_TEMPLATES_KEY = "org.eclipse.vjet.ui.text.custom_code_templates";
    private static final String CODE_TEMPLATES_MIGRATION_KEY = "org.eclipse.vjet.ui.text.code_templates_migrated";
    private ContextTypeRegistry fCodeTemplateContextTypeRegistry;
    private VjoTextTools fJavascriptTextTools;
    private ImageDescriptorRegistry m_imageDescriptorRegistry;

    public static VjetUIPlugin getDefault() {
        return s_plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public synchronized VjoTextTools getTextTools() {
        if (this.fJavascriptTextTools == null) {
            this.fJavascriptTextTools = new VjoTextTools(true);
        }
        return this.fJavascriptTextTools;
    }

    public void start(BundleContext context) throws Exception {
        IPerspectiveDescriptor[] allSets;
        super.start(context);
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = allSets = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        int n = allSets.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor iPerspectiveDescriptor = iPerspectiveDescriptorArray[n2];
            if (iPerspectiveDescriptor.getId().contains("VJET_JS")) {
                PlatformUI.getWorkbench().getPerspectiveRegistry().deletePerspective(iPerspectiveDescriptor);
            }
            ++n2;
        }
        VjetUIPlugin.setPluginInstance(this);
        FormatterProfileStore.checkCurrentOptionsVersion();
        IEditorRegistry editorRegistry = VjetUIPlugin.getDefault().getWorkbench().getEditorRegistry();
        editorRegistry.setDefaultEditor(this.getExtentionPattern(), "org.eclipse.vjet.ui.VjetJsEditor");
    }

    private String getExtentionPattern() {
        return "*." + VjoEditor.getDefaultContentType().getFileSpecs(8)[0];
    }

    private void reloadFont() {
        FontRegistry registry = JFaceResources.getFontRegistry();
        if (registry.defaultFont().equals((Object)registry.get("org.eclipse.jface.textfont"))) {
            FontData[] datas = registry.getFontData("org.eclipse.jface.textfont");
            registry.put("org.eclipse.jface.textfont", registry.defaultFont().getFontData());
            registry.put("org.eclipse.jface.textfont", datas);
        }
    }

    private void registryAdvisor() {
        ExternalFileEditorInput.registryAdvisor((IModelElementFileAdivsor)new NativeElementFileAdvisor());
    }

    public void stop(BundleContext context) throws Exception {
        VjetUIPlugin.setPluginInstance(null);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            window.getPartService().removePartListener(this.partListener);
        }
        super.stop(context);
    }

    private static void setPluginInstance(VjetUIPlugin pluginPar) {
        s_plugin = pluginPar;
    }

    public TemplateStore getCodeTemplateStore() {
        if (this.fCodeTemplateStore == null) {
            IPreferenceStore store = this.getPreferenceStore();
            boolean alreadyMigrated = store.getBoolean(CODE_TEMPLATES_MIGRATION_KEY);
            if (alreadyMigrated) {
                this.fCodeTemplateStore = new ContributionTemplateStore(this.getCodeTemplateContextRegistry(), store, CODE_TEMPLATES_KEY);
            } else {
                this.fCodeTemplateStore = new CompatibilityTemplateStore(this.getCodeTemplateContextRegistry(), store, CODE_TEMPLATES_KEY, this.getOldCodeTemplateStoreInstance());
                store.setValue(CODE_TEMPLATES_MIGRATION_KEY, true);
            }
            try {
                this.fCodeTemplateStore.load();
            }
            catch (IOException e) {
                DLTKUIPlugin.log((Throwable)e);
            }
            this.fCodeTemplateStore.startListeningForPreferenceChanges();
            CompatibilityTemplateStore.pruneDuplicates(this.fCodeTemplateStore, true);
        }
        return this.fCodeTemplateStore;
    }

    public ContextTypeRegistry getCodeTemplateContextRegistry() {
        if (this.fCodeTemplateContextTypeRegistry == null) {
            this.fCodeTemplateContextTypeRegistry = new ContributionContextTypeRegistry();
            CodeTemplateContextType.registerContextTypes(this.fCodeTemplateContextTypeRegistry);
        }
        return this.fCodeTemplateContextTypeRegistry;
    }

    private CodeTemplates getOldCodeTemplateStoreInstance() {
        return CodeTemplates.getInstance();
    }

    public static VjoEditor getVjoEditor() {
        IEditorPart part = VjetUIPlugin.getActivePage().getActiveEditor();
        if (part instanceof VjoEditor) {
            return (VjoEditor)part;
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static void log(int severity, String message) {
        VjetUIPlugin.log((IStatus)new Status(severity, PLUGIN_ID, severity, message, null));
    }

    public static void log(Exception e) {
        VjetUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, null, (Throwable)e));
    }

    public static void log(IStatus status) {
        VjetUIPlugin.getDefault().getLog().log(status);
    }

    public void earlyStartup() {
        System.out.println("Vjet UI early startup.");
        new WorkbenchJob("Starting VJET UI plugin"){

            public IStatus runInUIThread(IProgressMonitor arg0) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                window.getPartService().addPartListener(VjetUIPlugin.this.partListener);
                VjetUIPlugin.this.registryAdvisor();
                VjetUIPlugin.this.reloadFont();
                return new Status(0, VjetUIPlugin.PLUGIN_ID, 0, "Finished creating part", null);
            }
        }.schedule();
    }
}

