/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.view.scriptunit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;

class ScriptUnitTreeContentProvider
implements ITreeContentProvider {
    private IJstType scriptUnit;

    ScriptUnitTreeContentProvider() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement.getClass().isArray()) {
            return (Object[])parentElement;
        }
        if (parentElement instanceof IJstType) {
            IJstType jstType = (IJstType)parentElement;
            ArrayList children = new ArrayList();
            if (jstType.getEmbededTypes() != null) {
                Collections.addAll(children, jstType.getEmbededTypes().toArray());
            }
            Collections.addAll(children, jstType.getChildren().toArray());
            return children.toArray();
        }
        if (parentElement instanceof BaseJstNode) {
            List children = ((BaseJstNode)parentElement).getChildren();
            return children.toArray(new BaseJstNode[children.size()]);
        }
        return new Object[0];
    }

    private Object[] getScriptUnitChildren(IJstType scriptUnit) {
        ArrayList<IJstType> children = new ArrayList<IJstType>();
        if (scriptUnit != null) {
            children.add(scriptUnit);
        }
        if (scriptUnit.getJstBlockList() != null && scriptUnit.getJstBlockList().size() > 0) {
            children.addAll(scriptUnit.getJstBlockList());
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof IJstType) {
            if (((IJstType)element).getOuterType() != null) {
                return ((IJstType)element).getOuterType();
            }
            return this.scriptUnit;
        }
        if (element instanceof BaseJstNode) {
            return ((BaseJstNode)element).getParentNode();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setScriptUnit(IJstType scriptUnit) {
        this.scriptUnit = scriptUnit;
    }
}

