/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.view.properties;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.eclipse.internal.ui.nodeprinter.INodePrinter;

class JstNodePropertySourceAdapter
implements IPropertySource {
    private INodePrinter nodePrinter;
    private IPropertyDescriptor[] propertyDescriptors;
    private Object[] propertyValues;
    private IJstNode node;

    public JstNodePropertySourceAdapter(IJstNode jstNode, INodePrinter nodePrinter) {
        this.node = jstNode;
        this.nodePrinter = nodePrinter;
        this.propertyValues = nodePrinter.getPropertyValuies(jstNode);
        String[] propertyNames = this.nodePrinter.getPropertyNames(jstNode);
        this.propertyDescriptors = new PropertyDescriptor[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            this.propertyDescriptors[i] = new PropertyDescriptor((Object)propertyNames[i], propertyNames[i]);
            ++i;
        }
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        int i = 0;
        while (i < this.propertyDescriptors.length) {
            if (this.propertyDescriptors[i].getId().equals(id)) {
                return this.propertyValues[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public String toString() {
        return this.node.getClass().getName();
    }
}

