/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text.folding;

import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelElementVisitor;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ISourceRange;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.SourceRefElement;
import org.eclipse.dltk.mod.internal.core.SourceType;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.dltk.mod.ui.text.folding.IElementCommentResolver;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class VjetElementCommentResolver
implements IElementCommentResolver {
    protected IModelElement getContainingElement(IModelElement el, int offset, int length) throws ModelException {
        PositionVisitor visitor = new PositionVisitor(offset, length);
        el.accept((IModelElementVisitor)visitor);
        return visitor.result;
    }

    public IModelElement getElementByCommentPosition(ISourceModule content, int offset, int length) {
        try {
            return this.getElementByCommentPositionImpl(content, offset, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    protected IModelElement getElementByCommentPositionImpl(ISourceModule content, int offset, int length) throws BadLocationException, ModelException {
        Document d = new Document(content.getSource());
        IModelElement el = this.getContainingElement((IModelElement)content, offset, length);
        if (el != null && el.getElementType() == 9) {
            return el;
        }
        int sourceRangeEnd = this.getSourceRangeEnd(d, el);
        IModelElement res = this.searchForNonCommentElement(d, content, offset + length, sourceRangeEnd);
        if (res == null) {
            return el;
        }
        return res;
    }

    protected int getSourceRangeEnd(Document d, IModelElement el) throws ModelException {
        int sourceRangeEnd = d.getLength();
        if (el != null && el.getElementType() == 7) {
            SourceType t = (SourceType)el;
            sourceRangeEnd = t.getSourceRange().getOffset() + t.getSourceRange().getLength();
        }
        return sourceRangeEnd;
    }

    /*
     * Unable to fully structure code
     */
    protected IModelElement searchForNonCommentElement(Document d, ISourceModule content, int endOfCommentOffset, int lowerbound) throws BadLocationException, ModelException {
        res = null;
        off = endOfCommentOffset;
        line = d.getLineOfOffset(off);
        off = d.getLineOffset(line);
        ** GOTO lbl13
        {
            ++off;
            do {
                if (off < lowerbound - 1 && Character.isWhitespace(d.getChar(off))) continue block0;
                if (d.getChar(off) != '#') {
                    res = content.getElementAt(off);
                    break block0;
                }
                off = d.getLineOffset(++line);
lbl13:
                // 2 sources

            } while (off < lowerbound);
        }
        return res;
    }

    private static class PositionVisitor
    implements IModelElementVisitor {
        IModelElement result = null;
        private final int commentOffset;
        private final int commentLength;
        private int lowestOffset = -1;

        public PositionVisitor(int offset, int length) {
            this.commentOffset = offset;
            this.commentLength = length;
        }

        public boolean visit(IModelElement el) {
            if (el instanceof IType || el instanceof IMethod || el instanceof ISourceModule || el instanceof IField) {
                block10: {
                    ISourceRange range;
                    block11: {
                        range = null;
                        if (el instanceof VjoSourceModule) {
                            range = ((VjoSourceModule)el).getSourceRange();
                        }
                        if (el instanceof SourceRefElement) {
                            range = ((SourceRefElement)el).getSourceRange();
                        }
                        if (range == null) break block10;
                        if (this.commentOffset < range.getOffset() || this.commentOffset + this.commentLength > range.getOffset() + range.getLength() || el.getElementType() != 9) break block11;
                        this.result = el;
                        return false;
                    }
                    try {
                        if (this.commentOffset + this.commentLength <= range.getOffset()) {
                            int offsetDistance = range.getOffset() - this.commentOffset;
                            if (this.result == null || offsetDistance < this.lowestOffset) {
                                if (el instanceof VjoSourceModule) {
                                    this.result = ((VjoSourceModule)el).getTypes()[0];
                                    this.lowestOffset = offsetDistance;
                                }
                                if (el.getElementType() == 9 || el.getElementType() == 7 || el.getElementType() == 8) {
                                    this.result = el;
                                    this.lowestOffset = offsetDistance;
                                }
                            }
                        }
                    }
                    catch (ModelException e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
            return false;
        }
    }
}

