/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.search.SearchMatch;
import org.eclipse.vjet.eclipse.internal.ui.refactoring.core.SourceModuleCollectingSearchRequestor;

public class TypeOccurrenceCollector
extends SourceModuleCollectingSearchRequestor {
    final String fOldName;
    final String fOldQualifiedName;

    public TypeOccurrenceCollector(IType type) {
        this.fOldName = type.getElementName();
        this.fOldQualifiedName = type.getFullyQualifiedName(".");
    }

    @Override
    public void acceptSearchMatch(ISourceModule unit, SearchMatch match) throws CoreException {
        this.collectMatch(this.acceptSearchMatch2(unit, match));
    }

    public SearchMatch acceptSearchMatch2(ISourceModule unit, SearchMatch match) throws CoreException {
        int start = match.getOffset();
        int length = match.getLength();
        String matchText = unit.getBuffer().getText(start, length);
        if (this.fOldName.equals(matchText)) {
            return match;
        }
        if (this.fOldQualifiedName.endsWith(matchText)) {
            int simpleNameLenght = this.fOldName.length();
            match.setOffset(start + length - simpleNameLenght);
            match.setLength(simpleNameLenght);
            return match;
        }
        return match;
    }
}

