/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.editor;

import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.internal.ui.actions.FoldingActionGroup;
import org.eclipse.dltk.mod.internal.ui.editor.BracketInserter;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptOutlinePage;
import org.eclipse.dltk.mod.ui.text.ScriptTextTools;
import org.eclipse.dltk.mod.ui.text.folding.IFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.vjet.eclipse.core.VjoLanguageToolkit;
import org.eclipse.vjet.eclipse.internal.ui.editor.JavaScriptBracketInserter;
import org.eclipse.vjet.eclipse.internal.ui.editor.JavaScriptDocumentSetupParticipant;
import org.eclipse.vjet.eclipse.internal.ui.editor.JavaScriptOutlinePage;
import org.eclipse.vjet.eclipse.internal.ui.text.JavaScriptPairMatcher;
import org.eclipse.vjet.eclipse.internal.ui.text.folding.VjoFoldingStructureProvider;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;
import org.eclipse.vjet.eclipse.ui.actions.JavaScriptGenerateActionGroup;

public class JavaScriptEditor
extends ScriptEditor {
    public static final String EDITOR_ID = "org.eclipse.dltk.mod.javascript.internal.ui.editor.JavascriptEditor";
    public static final String EDITOR_CONTEXT = "#JavascriptEditorContext";
    public static final String RULER_CONTEXT = "#JavascriptRulerContext";
    private BracketInserter fBracketInserter = new JavaScriptBracketInserter(this);
    private JavaScriptPairMatcher bracketMatcher = new JavaScriptPairMatcher("{}[]()".toCharArray());
    IFoldingStructureProvider fFoldingProvider = null;
    private static final String CLOSE_STRINGS = "closeStrings";
    private static final String CLOSE_BRACKETS = "closeBrackets";

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        boolean closeBrackets = preferenceStore.getBoolean(CLOSE_BRACKETS);
        boolean closeStrings = preferenceStore.getBoolean(CLOSE_STRINGS);
        boolean closeAngularBrackets = false;
        this.fBracketInserter.setCloseBracketsEnabled(closeBrackets);
        this.fBracketInserter.setCloseStringsEnabled(closeStrings);
        this.fBracketInserter.setCloseAngularBracketsEnabled(closeAngularBrackets);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId(EDITOR_CONTEXT);
        this.setRulerContextMenuId(RULER_CONTEXT);
    }

    protected IPreferenceStore getScriptPreferenceStore() {
        return VjetUIPlugin.getDefault().getPreferenceStore();
    }

    public ScriptTextTools getTextTools() {
        return VjetUIPlugin.getDefault().getTextTools();
    }

    protected ScriptOutlinePage doCreateOutlinePage() {
        return new JavaScriptOutlinePage(this, VjetUIPlugin.getDefault().getPreferenceStore());
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.bracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("editor.matching_brackets", "editor.matching_brackets_color");
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void connectPartitioningToElement(IEditorInput input, IDocument document) {
        IDocumentExtension3 extension;
        if (document instanceof IDocumentExtension3 && (extension = (IDocumentExtension3)document).getDocumentPartitioner("__javascript_partitioning") == null) {
            JavaScriptDocumentSetupParticipant participant = new JavaScriptDocumentSetupParticipant();
            participant.setup(document);
        }
    }

    protected IFoldingStructureProvider getFoldingStructureProvider() {
        if (this.fFoldingProvider == null) {
            this.fFoldingProvider = new VjoFoldingStructureProvider();
        }
        return this.fFoldingProvider;
    }

    protected FoldingActionGroup createFoldingActionGroup() {
        return new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getViewer(), VjetUIPlugin.getDefault().getPreferenceStore());
    }

    public String getEditorId() {
        return EDITOR_ID;
    }

    public IDLTKLanguageToolkit getLanguageToolkit() {
        return VjoLanguageToolkit.getDefault();
    }

    public String getCallHierarchyID() {
        return "org.eclipse.dltk.mod.callhierarchy.view";
    }

    public void dispose() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        super.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            String p = event.getProperty();
            if (CLOSE_BRACKETS.equals(p)) {
                this.fBracketInserter.setCloseBracketsEnabled(this.getPreferenceStore().getBoolean(p));
                return;
            }
            if (!CLOSE_STRINGS.equals(p)) return;
            this.fBracketInserter.setCloseStringsEnabled(this.getPreferenceStore().getBoolean(p));
            return;
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.dltk.mod.ui.scriptEditorScope"});
    }

    protected void createActions() {
        super.createActions();
        JavaScriptGenerateActionGroup generateActions = new JavaScriptGenerateActionGroup(this, "group.edit");
        this.fActionGroups.addGroup((ActionGroup)generateActions);
        this.fContextMenuGroup.addGroup((ActionGroup)generateActions);
    }
}

