/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.actions;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.vjet.eclipse.core.PiggyBackClassPathUtil;

public class UpdateVjetBuildPathFromJavaClasspathAction
implements IExecutableExtension,
IObjectActionDelegate {
    ISelection selection;

    public void run(IAction action) {
        IAdaptable adaptable;
        IProject project;
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
        if (structuredSelection.isEmpty() || structuredSelection.size() > 1) {
            return;
        }
        Object selectionElement = structuredSelection.getFirstElement();
        if (selectionElement instanceof IAdaptable && (project = (IProject)(adaptable = (IAdaptable)selectionElement).getAdapter(IProject.class)) != null) {
            this.doUpdate(project);
        }
    }

    private void doUpdate(IProject project) {
        PiggyBackClassPathUtil.initializeScriptProjectFromJavProject((IScriptProject)DLTKCore.create((IProject)project));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        IAdaptable adaptable = (IAdaptable)((IStructuredSelection)selection).getFirstElement();
        if (adaptable == null) {
            return;
        }
        IProject project = (IProject)adaptable.getAdapter(IProject.class);
        boolean hasVJONature = this.hasVJONature(project);
        boolean hasVJOBuilder = this.hasVJOBuilder(project);
        if (hasVJONature && hasVJOBuilder) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasVJONature(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] buildCommands = description.getBuildSpec();
            int i = 0;
            while (true) {
                if (i >= buildCommands.length) {
                    return false;
                }
                if ("org.eclipse.dltk.mod.core.scriptbuilder".equals(buildCommands[i].getBuilderName())) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean hasVJOBuilder(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            return description.hasNature("org.eclipse.vjet.core.nature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

