/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.dbgp.IDbgpSession;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.mod.launching.sourcelookup.Messages;
import org.eclipse.vjet.dsf.common.StringUtils;
import org.eclipse.vjet.eclipse.launching.VjetLaunchingPlugin;

public class VjoDBGPSourceStorage
implements IStorage {
    private static final char CHAR_NEW_LINE = '\n';
    private String m_cachedSource = null;
    private IDbgpSession m_session;
    private URI m_uri;
    private String m_name;

    public VjoDBGPSourceStorage(URI uri, IDbgpSession session) {
        this.m_uri = uri;
        this.m_session = session;
    }

    public Object getAdapter(Class adapter) {
        return adapter.isAssignableFrom(this.getClass());
    }

    public InputStream getContents() throws CoreException {
        try {
            byte[] contents = this.lookupSource().getBytes();
            return new ByteArrayInputStream(contents);
        }
        catch (DbgpException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.vjet.eclipse.launching", Messages.DBGPSourceModule_dbgpSourceLookup, (Throwable)e));
        }
    }

    public IPath getFullPath() {
        return new Path(this.m_uri.toString());
    }

    public String getName() {
        try {
            if (this.m_name == null) {
                String source = this.lookupSource();
                this.m_name = this.getCodeSnippt(source);
            }
            return this.m_name;
        }
        catch (DbgpException e) {
            VjetLaunchingPlugin.error(e.getLocalizedMessage(), e);
            return "";
        }
    }

    private String getCodeSnippt(String source) {
        return this.getContents(source, 1, 2);
    }

    private String getContents(String source, int beginLine, int endLine) {
        StringBuilder builder;
        block6: {
            List lines;
            block7: {
                block5: {
                    if (source == null || source.length() == 0) {
                        return "";
                    }
                    if (beginLine == -1 && endLine == -1) {
                        return source;
                    }
                    lines = StringUtils.splitStr((String)source, (char)'\n');
                    int lineLength = lines.size();
                    endLine = endLine > lineLength + 1 ? -1 : endLine;
                    builder = new StringBuilder();
                    if (beginLine == -1 || endLine != -1) break block5;
                    int i = beginLine - 1;
                    while (i < lineLength) {
                        this.appendLine(builder, (String)lines.get(i));
                        ++i;
                    }
                    break block6;
                }
                if (beginLine != -1 || endLine == -1) break block7;
                int len = endLine - 1;
                int i = 0;
                while (i < len) {
                    this.appendLine(builder, (String)lines.get(i));
                    ++i;
                }
                break block6;
            }
            if (beginLine == -1 || endLine == -1) break block6;
            int len = endLine - 1;
            int i = beginLine - 1;
            while (i < len) {
                this.appendLine(builder, (String)lines.get(i));
                ++i;
            }
        }
        return builder.toString();
    }

    private StringBuilder appendLine(StringBuilder builder, String line) {
        return builder.append(line).append('\n');
    }

    public URI getURI() {
        return this.m_uri;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void setSession(IDbgpSession session) {
        this.m_session = session;
    }

    private String lookupSource() throws DbgpException {
        if (this.m_cachedSource == null) {
            this.m_cachedSource = this.m_session.getCoreCommands().getSource(this.m_uri);
        }
        return this.m_cachedSource;
    }
}

