/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.mod.internal.launching.LaunchConfigurationUtils;
import org.eclipse.vjet.eclipse.internal.launching.LauncherUtil;
import org.eclipse.vjet.eclipse.launching.VjetLaunchingPlugin;

public class VjetSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    public Object[] findSourceElements(Object element) throws CoreException {
        Object source = null;
        URI uri = null;
        if (element instanceof ScriptStackFrame) {
            ScriptStackFrame sf = (ScriptStackFrame)element;
            uri = sf.getFileName();
        } else if (element instanceof URI) {
            uri = (URI)element;
        }
        if (uri == null) {
            return new Object[0];
        }
        String scheme = (uri = uri.normalize()).getScheme();
        if (LauncherUtil.isFileScheme(scheme)) {
            source = this.getSourceFromFileURI(uri);
        } else if (LauncherUtil.isZipScheme(scheme) && source == null) {
            try {
                source = LauncherUtil.createZipEntryFile(uri);
            }
            catch (Exception e) {
                VjetLaunchingPlugin.error(e.getLocalizedMessage(), e);
            }
        }
        if (source != null) {
            return new Object[]{source};
        }
        return new Object[0];
    }

    public String getSourceName(Object object) throws CoreException {
        ScriptStackFrame frame = (ScriptStackFrame)object;
        String path = frame.getFileName().getPath();
        if (path.length() == 0) {
            return null;
        }
        String root = this.getProjectRoot();
        if (path.indexOf(root) != -1) {
            return path.substring(root.length() + 1);
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(path));
        IProject project = this.getProject();
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            if (file.exists() && file.getProject().equals((Object)project)) {
                return file.getProjectRelativePath().toString();
            }
            ++i;
        }
        return path;
    }

    protected String getProjectRoot() throws CoreException {
        IProject project = this.getProject();
        return project.getLocationURI().getPath();
    }

    private IProject getProject() {
        return LaunchConfigurationUtils.getProject((ILaunchConfiguration)this.getDirector().getLaunchConfiguration());
    }

    private Object getSourceFromFileURI(URI uri) {
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
        if (files != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    public static Object findFileElement(String path) {
        File file = new File(path);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer container = root.getContainerForLocation((IPath)new Path(file.getParent()));
        if (container != null) {
            IResource resource = container.findMember(file.getName());
            if (resource instanceof IFile) {
                return resource;
            }
        } else {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath location = Path.fromOSString((String)file.getAbsolutePath());
            IFile ifile = workspace.getRoot().getFile(location);
            if (ifile.exists()) {
                return ifile;
            }
            if (file.exists()) {
                return EnvironmentPathUtils.getFile((IEnvironment)EnvironmentManager.getLocalEnvironment(), (IPath)location);
            }
        }
        return null;
    }
}

