/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IAccessRule;
import org.eclipse.dltk.mod.core.IBuildpathContainer;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IBuiltinModuleProvider;
import org.eclipse.dltk.mod.core.IInterpreterContainerExtension;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.launching.IInterpreterInstall;
import org.eclipse.dltk.mod.launching.IInterpreterInstallChangedListener;
import org.eclipse.dltk.mod.launching.PropertyChangeEvent;
import org.eclipse.dltk.mod.launching.ScriptRuntime;
import org.eclipse.vjet.eclipse.internal.core.util.Util;
import org.eclipse.vjet.vjo.lib.TsLibLoader;

public class JsSdkBuildpathContainer
implements IBuildpathContainer {
    private IPath fPath = null;
    private List m_entries;
    private static Map fgBuildpathEntries = null;
    private static IAccessRule[] EMPTY_RULES = new IAccessRule[0];

    private IBuildpathEntry[] getBuildpathEntries() {
        IBuildpathEntry[] entries;
        if (fgBuildpathEntries == null) {
            fgBuildpathEntries = new HashMap(10);
            IInterpreterInstallChangedListener listener = new IInterpreterInstallChangedListener(){

                public void defaultInterpreterInstallChanged(IInterpreterInstall previous, IInterpreterInstall current) {
                }

                public void interpreterChanged(PropertyChangeEvent event) {
                    if (event.getSource() != null) {
                        fgBuildpathEntries.remove(event.getSource());
                    }
                }

                public void interpreterAdded(IInterpreterInstall newInterpreter) {
                }

                public void interpreterRemoved(IInterpreterInstall removedInterpreter) {
                    fgBuildpathEntries.remove(removedInterpreter);
                }
            };
            ScriptRuntime.addInterpreterInstallChangedListener((IInterpreterInstallChangedListener)listener);
        }
        if ((entries = (IBuildpathEntry[])fgBuildpathEntries.get(this.fPath.lastSegment())) == null) {
            entries = this.computeBuildpathEntries(this.fPath.lastSegment());
            fgBuildpathEntries.put(this.fPath.lastSegment(), entries);
        }
        return entries;
    }

    private IPath getSdkBasePath(String groupName) {
        return new Path(Util.getNativeTypeCacheDir((String)groupName).toString());
    }

    private IBuildpathEntry[] computeBuildpathEntries(String sdkName) {
        List entries = this.m_entries;
        return entries.toArray(new IBuildpathEntry[entries.size()]);
    }

    public JsSdkBuildpathContainer(IInterpreterInstall interpreter, IPath path) {
        this.fPath = path;
    }

    public IBuildpathEntry[] getBuildpathEntries(IScriptProject project) {
        IBuildpathEntry[] buildpathEntries = this.getBuildpathEntries();
        ArrayList<IBuildpathEntry> entries = new ArrayList<IBuildpathEntry>();
        entries.addAll(Arrays.asList(buildpathEntries));
        IInterpreterContainerExtension extension = DLTKLanguageManager.getInterpreterContainerExtensions((IScriptProject)project);
        if (extension != null) {
            extension.processEntres(project, entries);
        }
        return entries.toArray(new IBuildpathEntry[entries.size()]);
    }

    public String getDescription(IScriptProject project) {
        String sdkName = this.fPath.lastSegment();
        return String.valueOf(sdkName) + "[" + "JS Native Types" + "]";
    }

    public int getKind() {
        return 3;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public IBuiltinModuleProvider getBuiltinProvider(IScriptProject project) {
        return new IBuiltinModuleProvider(){

            public String getBuiltinModuleContent(String name) {
                return "";
            }

            public String[] getBuiltinModules() {
                return TsLibLoader.getDefaultLibNames();
            }

            public long lastModified() {
                return 0L;
            }
        };
    }

    public void setEntries(List createEntries) {
        this.m_entries = createEntries;
    }
}

