/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui.html;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.dltk.mod.debug.ui.breakpoints.ScriptToggleBreakpointAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.vjet.eclipse.internal.debug.ui.html.HtmlBreakpointUtils;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.text.XMLStructuredDocumentRegion;

public class HtmlScriptToggleBreakpointAdapter
extends ScriptToggleBreakpointAdapter {
    protected String getDebugModelId() {
        return "org.eclipse.vjet.eclipse.debug.vjetModel";
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (!this.isInVjoProject(part)) {
            return false;
        }
        IStructuredDocument structuredDocument = this.getStructuredDocument(part);
        if (structuredDocument == null) {
            return false;
        }
        IStructuredDocumentRegion structuredDocumentRegion = structuredDocument.getRegionAtCharacterOffset(((ITextSelection)selection).getOffset());
        return this.isInHtmlScriptBlock(structuredDocumentRegion);
    }

    private boolean isInVjoProject(IWorkbenchPart part) {
        try {
            IFileEditorInput fileEditorInput = (IFileEditorInput)((IEditorPart)part).getEditorInput();
            IFile htmlFile = fileEditorInput.getFile();
            boolean isVJOProject = htmlFile.getProject().getDescription().hasNature("org.eclipse.vjet.core.nature");
            return isVJOProject;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private IStructuredDocument getStructuredDocument(IWorkbenchPart part) {
        IEditorInput editorInput = ((TextEditor)part).getEditorInput();
        IDocument document = ((TextEditor)part).getDocumentProvider().getDocument((Object)editorInput);
        if (document instanceof IStructuredDocument) {
            return (IStructuredDocument)document;
        }
        return null;
    }

    private boolean isInHtmlScriptBlock(IStructuredDocumentRegion structuredDocumentRegion) {
        if ("BLOCK_TEXT" != structuredDocumentRegion.getType()) {
            return false;
        }
        IStructuredDocumentRegion scriptBeginRegion = this.getRelatedScriptBeginRegion(structuredDocumentRegion);
        IStructuredDocumentRegion scriptEndRegion = this.getRelatedScriptEndRegion(structuredDocumentRegion);
        return scriptBeginRegion != null && scriptEndRegion != null;
    }

    private IStructuredDocumentRegion getRelatedScriptBeginRegion(IStructuredDocumentRegion structuredDocumentRegion) {
        while (structuredDocumentRegion.getPrevious() != null) {
            if (!((structuredDocumentRegion = structuredDocumentRegion.getPrevious()) instanceof XMLStructuredDocumentRegion) || structuredDocumentRegion.getFirstRegion().getType() != "XML_TAG_OPEN") continue;
            ITextRegionList textRegionList = structuredDocumentRegion.getRegions();
            for (ITextRegion textRegion : textRegionList) {
                if ("XML_TAG_NAME" != textRegion.getType() || !structuredDocumentRegion.getText(textRegion).equals("script")) continue;
                return structuredDocumentRegion;
            }
        }
        return null;
    }

    private IStructuredDocumentRegion getRelatedScriptEndRegion(IStructuredDocumentRegion structuredDocumentRegion) {
        while (structuredDocumentRegion.getNext() != null) {
            if (!((structuredDocumentRegion = structuredDocumentRegion.getNext()) instanceof XMLStructuredDocumentRegion) || !"</script>".equals(structuredDocumentRegion.getText())) continue;
            return structuredDocumentRegion;
        }
        return null;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IStructuredDocument structuredDocument = this.getStructuredDocument(part);
        IStructuredDocumentRegion structuredDocumentRegion = structuredDocument.getRegionAtCharacterOffset(((ITextSelection)selection).getOffset());
        this.getScriptStartLineNumber(structuredDocumentRegion);
        int selectionLineNumber = ((ITextSelection)selection).getStartLine() + 1;
        ILineBreakpoint breakpoint = HtmlBreakpointUtils.findLineBreakpoint((ITextEditor)((TextEditor)part), selectionLineNumber);
        if (breakpoint != null) {
            breakpoint.delete();
            return;
        }
        HtmlBreakpointUtils.addLineBreakpoint((ITextEditor)((TextEditor)part), selectionLineNumber);
    }

    private int getScriptStartLineNumber(IStructuredDocumentRegion selectedRegion) {
        IStructuredDocumentRegion scripBeginRegion = this.getRelatedScriptBeginRegion(selectedRegion);
        int scriptStartDocumentLineNumber = selectedRegion.getParentDocument().getLineOfOffset(scripBeginRegion.getStartOffset());
        return scriptStartDocumentLineNumber;
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }
}

