/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.dltk.mod.core.Flags;
import org.eclipse.dltk.mod.core.ICodeAssist;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.mod.debug.core.model.IScriptLineBreakpoint;
import org.eclipse.dltk.mod.debug.core.model.IScriptMethodEntryBreakpoint;
import org.eclipse.dltk.mod.debug.ui.breakpoints.BreakpointUtils;
import org.eclipse.dltk.mod.debug.ui.breakpoints.ScriptToggleBreakpointAdapter;
import org.eclipse.dltk.mod.internal.debug.core.model.AbstractScriptBreakpoint;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptDebugModel;
import org.eclipse.dltk.mod.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.editor.WorkingCopyManager;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.vjet.eclipse.debug.ui.VjetDebugUIPlugin;
import org.eclipse.vjet.eclipse.internal.debug.ui.DBGPScriptCacheManager;
import org.eclipse.vjet.eclipse.internal.launching.VjoDBGPSourceModule;

public class VjetToggleBreakpointAdapter
extends ScriptToggleBreakpointAdapter {
    private DBGPScriptCacheManager m_cacheManger = DBGPScriptCacheManager.getDefault();

    protected String getDebugModelId() {
        return "org.eclipse.vjet.eclipse.debug.vjetModel";
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection;
            int lineNumber;
            ITextEditor textEditor = this.getTextEditor(part);
            ILineBreakpoint breakpoint = BreakpointUtils.findLineBreakpoint((ITextEditor)textEditor, (int)(lineNumber = (textSelection = (ITextSelection)selection).getStartLine() + 1));
            if (breakpoint != null) {
                breakpoint.delete();
                return;
            }
            if (textEditor instanceof ScriptEditor) {
                ScriptEditor scriptEditor = (ScriptEditor)textEditor;
                try {
                    int apos;
                    IDocument doc = scriptEditor.getScriptSourceViewer().getDocument();
                    IRegion region = doc.getLineInformation(lineNumber - 1);
                    String string = doc.get(region.getOffset(), region.getLength());
                    int index = string.indexOf("function");
                    if (index != -1 && (apos = (string = string.substring(index + "function".length()).trim()).indexOf(40)) >= 0) {
                        string = string.substring(0, apos).trim();
                    }
                }
                catch (BadLocationException e) {
                    DLTKDebugPlugin.log((Throwable)e);
                    return;
                }
            }
            this.createLineBreakpoint(textEditor, lineNumber);
        }
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return this.getMethods(ss).length > 0;
        }
        return selection instanceof ITextSelection && this.isMethod((ITextSelection)selection, part);
    }

    protected IMethod[] getMethods(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new IMethod[0];
        }
        ArrayList<IMethod> methods = new ArrayList<IMethod>(selection.size());
        for (Object thing : selection) {
            try {
                IMethod method;
                if (!(thing instanceof IMethod) || Flags.isAbstract((int)(method = (IMethod)thing).getFlags())) continue;
                methods.add(method);
            }
            catch (ModelException modelException) {}
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    private boolean isMethod(ITextSelection selection, IWorkbenchPart part) {
        IModelElement element;
        ITextEditor editor = this.getTextEditor(part);
        if (editor != null && (element = this.getJavaElement(editor.getEditorInput())) != null) {
            try {
                IModelElement[] elements;
                if (element instanceof org.eclipse.dltk.mod.compiler.env.ISourceModule && (elements = ((ICodeAssist)((org.eclipse.dltk.mod.compiler.env.ISourceModule)element)).codeSelect(selection.getOffset(), selection.getLength())) != null) {
                    IModelElement iModelElement = element = elements.length > 0 ? elements[0] : null;
                }
                return element != null && element.getElementType() == 9;
            }
            catch (ModelException modelException) {
                return false;
            }
        }
        return false;
    }

    private IModelElement getJavaElement(IEditorInput input) {
        ISourceModule je = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)input);
        if (je != null) {
            return je;
        }
        return ((WorkingCopyManager)DLTKUIPlugin.getDefault().getWorkingCopyManager()).getWorkingCopy(input, false);
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            String text = textSelection.getText();
            if (part instanceof ScriptEditor) {
                ScriptEditor scriptEditor = (ScriptEditor)part;
                try {
                    IDocument doc = scriptEditor.getScriptSourceViewer().getDocument();
                    IRegion region = doc.getLineInformation(textSelection.getStartLine());
                    String string = doc.get(region.getOffset(), region.getLength());
                    return string.indexOf(61) != -1 || string.trim().startsWith("var ");
                }
                catch (BadLocationException e) {
                    DLTKUIPlugin.log((Throwable)e);
                }
            }
            return text.indexOf("=") != -1;
        }
        return true;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection finalSelection) throws CoreException {
        if (!this.canToggleMethodBreakpoints(part, finalSelection)) {
            return;
        }
        IMethod[] methods = this.getMethods((IStructuredSelection)finalSelection);
        int i = 0;
        while (i < methods.length) {
            try {
                ITextEditor textEditor = this.getTextEditor(methods[i]);
                IDocumentProvider documentProvider = textEditor.getDocumentProvider();
                IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
                int methodSourceOffset = methods[i].getSourceRange().getOffset();
                int documentLineNumber = document.getLineOfOffset(methodSourceOffset);
                int scriptLineNumber = documentLineNumber + 1;
                ILineBreakpoint breakpoint = BreakpointUtils.findLineBreakpoint((ITextEditor)textEditor, (int)scriptLineNumber);
                if (breakpoint != null) {
                    breakpoint.delete();
                } else {
                    this.createMethodEntryBreakpoint(textEditor, scriptLineNumber, "");
                }
            }
            catch (Exception e) {
                VjetDebugUIPlugin.error(e.getLocalizedMessage(), e);
            }
            ++i;
        }
    }

    private ITextEditor getTextEditor(IMethod method) {
        try {
            IResource resource = method.getResource();
            IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return (ITextEditor)IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)((IFile)resource));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isInterface(ISelection selection, IWorkbenchPart part) {
        try {
            Object obj;
            ISelection sel = selection;
            if (!(sel instanceof IStructuredSelection)) {
                sel = this.translateToMembers(part, selection);
            }
            if (sel instanceof IStructuredSelection && (obj = ((IStructuredSelection)sel).getFirstElement()) instanceof IMember) {
                IMember member = (IMember)((IStructuredSelection)sel).getFirstElement();
                if (member.getElementType() == 7) {
                    return Flags.isInterface((int)((IType)member).getFlags());
                }
                return Flags.isInterface((int)member.getDeclaringType().getFlags());
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection);
    }

    private void createMethodEntryBreakpoint(ITextEditor textEditor, int lineNumber, String methodName) throws CoreException {
        IEditorInput editorInput = textEditor.getEditorInput();
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)editorInput);
        IResource resource = BreakpointUtils.getBreakpointResource((ITextEditor)textEditor);
        if (resource != null) {
            try {
                IRegion line = document.getLineInformation(lineNumber - 1);
                int start = line.getOffset();
                int end = start + line.getLength() - 1;
                IPath path = resource.getLocation();
                IScriptMethodEntryBreakpoint methodEntryBreakpoint = ScriptDebugModel.createMethodEntryBreakpoint((String)this.getDebugModelId(), (IResource)resource, (IPath)path, (int)lineNumber, (int)start, (int)end, (boolean)false, null, (String)methodName);
                methodEntryBreakpoint.setBreakOnEntry(true);
                ((AbstractScriptBreakpoint)methodEntryBreakpoint).register(true);
                if (this.needCache(editorInput)) {
                    this.add2Cache(editorInput, (IBreakpoint)methodEntryBreakpoint);
                }
            }
            catch (BadLocationException e) {
                VjetDebugUIPlugin.error(e.getLocalizedMessage(), e);
            }
        }
    }

    private void createLineBreakpoint(ITextEditor textEditor, int lineNumber) throws CoreException {
        IEditorInput editorInput = textEditor.getEditorInput();
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)editorInput);
        IResource resource = BreakpointUtils.getBreakpointResource((ITextEditor)textEditor);
        try {
            IRegion line = document.getLineInformation(lineNumber - 1);
            int start = line.getOffset();
            int end = start + line.getLength();
            IPath location = BreakpointUtils.getBreakpointResourceLocation((ITextEditor)textEditor);
            IScriptLineBreakpoint breakpoint = ScriptDebugModel.createLineBreakpoint((String)this.getDebugModelId(), (IResource)resource, (IPath)location, (int)lineNumber, (int)start, (int)end, (boolean)true, null);
            if (this.needCache(editorInput)) {
                this.add2Cache(editorInput, (IBreakpoint)breakpoint);
            }
        }
        catch (BadLocationException e) {
            VjetDebugUIPlugin.error(e.getLocalizedMessage(), e);
        }
    }

    private void add2Cache(IEditorInput editorInput, IBreakpoint breakpoint) throws CoreException {
        this.m_cacheManger.add(breakpoint, (IStorage)this.getVjoDBGPSourceModule(editorInput));
    }

    private boolean needCache(IEditorInput editorInput) {
        return this.getVjoDBGPSourceModule(editorInput) != null;
    }

    private VjoDBGPSourceModule getVjoDBGPSourceModule(IEditorInput editorInput) {
        IStorage storage;
        if (editorInput instanceof ExternalStorageEditorInput && (storage = ((ExternalStorageEditorInput)editorInput).getStorage()) instanceof VjoDBGPSourceModule) {
            return (VjoDBGPSourceModule)storage;
        }
        return null;
    }
}

