/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.codeassist.select.translator;

import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.internal.codeassist.select.translator.DefaultNodeTranslator;

public class JstObjectLiteralTypeTranslator
extends DefaultNodeTranslator {
    @Override
    public IModelElement[] convert(IJstNode jstNode) {
        IModelElement[] iModelElementArray;
        if (!(jstNode instanceof JstObjectLiteralType)) {
            return null;
        }
        IJstType jstType = (IJstType)jstNode.getParentNode();
        if (CodeassistUtils.isNativeType(jstType)) {
            IModelElement[] iModelElementArray2;
            IType type = CodeassistUtils.findNativeSourceType(jstType);
            if (type != null) {
                IModelElement[] iModelElementArray3 = new IModelElement[1];
                iModelElementArray2 = iModelElementArray3;
                iModelElementArray3[0] = type;
            } else {
                iModelElementArray2 = new IModelElement[]{};
            }
            return iModelElementArray2;
        }
        IType rootDLTKType = CodeassistUtils.findType(jstType.getRootType());
        if (rootDLTKType == null) {
            return null;
        }
        IType converted = this.getType(rootDLTKType, jstType.getName());
        JstObjectLiteralType jstObjectLiteralType = (JstObjectLiteralType)jstNode;
        if (converted instanceof IType && jstObjectLiteralType.getSimpleName() != null) {
            IField field = converted.getField(jstObjectLiteralType.getSimpleName());
            Object object = converted = field != null ? field : converted;
        }
        if (converted != null) {
            IModelElement[] iModelElementArray4 = new IModelElement[1];
            iModelElementArray = iModelElementArray4;
            iModelElementArray4[0] = converted;
        } else {
            iModelElementArray = new IModelElement[]{};
        }
        return iModelElementArray;
    }

    @Override
    public IModelElement[] convert(IVjoSourceModule module, IJstNode jstNode) {
        IModelElement[] iModelElementArray;
        if (!(jstNode instanceof JstObjectLiteralType)) {
            return null;
        }
        IJstType jstType = (IJstType)jstNode.getParentNode();
        IScriptProject sProject = null;
        if (module != null) {
            sProject = module.getScriptProject();
        }
        IType mElement = null;
        if (sProject != null && (!CodeassistUtils.isNativeType(jstType) || CodeassistUtils.isBinaryType(jstType))) {
            mElement = CodeassistUtils.findType((ScriptProject)sProject, jstType);
        }
        if (mElement == null) {
            mElement = this.convert(jstNode)[0];
        }
        JstObjectLiteralType jstObjectLiteralType = (JstObjectLiteralType)jstNode;
        if (mElement instanceof IType && jstObjectLiteralType.getSimpleName() != null) {
            IField field = mElement.getField(jstObjectLiteralType.getSimpleName());
            Object object = mElement = field != null ? field : mElement;
        }
        if (mElement != null) {
            IModelElement[] iModelElementArray2 = new IModelElement[1];
            iModelElementArray = iModelElementArray2;
            iModelElementArray2[0] = mElement;
        } else {
            iModelElementArray = new IModelElement[]{};
        }
        return iModelElementArray;
    }

    private IType getType(IType rootType, String dltkTypeName) {
        try {
            if (rootType.getFullyQualifiedName(".").equals(dltkTypeName)) {
                return rootType;
            }
            IType[] types = rootType.getTypes();
            int i = 0;
            while (i < types.length) {
                IType type = this.getType(types[i], dltkTypeName);
                if (type != null) {
                    return type;
                }
                ++i;
            }
        }
        catch (ModelException e) {
            VjetPlugin.error(e.getLocalizedMessage(), e);
        }
        return null;
    }
}

